UPDATE OTParameters
SET
    CalculationEndDate = (
        CASE
            WHEN (SELECT Value FROM ServerSettings WHERE Name = 'OperationTime:LastCalculationTime') IN ('default_value', NULL)
                THEN NULL
            ELSE (SELECT Value FROM ServerSettings WHERE Name = 'OperationTime:LastCalculationTime')
            END
        ),
    CalculationStartDate = (
        CASE
            WHEN EXISTS (
                SELECT 1 FROM OTRecords
                                  JOIN OTDevices ON OTDevices.Id = OTRecords.DeviceId
                WHERE OTDevices.ParameterId = OTParameters.Id
            )
                THEN (
                SELECT MIN(OTRecords.TimeStamp)
                FROM OTRecords
                         JOIN OTDevices ON OTDevices.Id = OTRecords.DeviceId
                WHERE OTDevices.ParameterId = OTParameters.Id
            )
            ELSE CalculationStartDate
            END
        );
