// $License: NOLICENSE
//--------------------------------------------------------------------------------
/**
  Функции по работе с временем

  @file $relPath
  @copyright $copyright
  @author SMS-Automation
*/

//--------------------------------------------------------------------------------
// Libraries used (#uses)

//--------------------------------------------------------------------------------
// Variables and Constants


//--------------------------------------------------------------------------------
//@public members
//--------------------------------------------------------------------------------

/** Добавить миллисекунды к переданному времени
  @param t Временная метка
  @param milliseconds Миллисекунды
  @return Метка времени
*/
time addMillisecondsTD(time t, int milliseconds)
{
  time difference = makeTime(1970, 1, 1, 0, 0, 0 + timeFromGMT(), abs(milliseconds));
  return milliseconds >= 0 ? t + difference : t - difference;
}

/** Преобразовать временную метку к строке в формате ТехноДок
  @param arg Временная метка
  @return Временная метка в виде строки
*/
string timeToStringForUtcTD(time arg)
{
  string s = year(arg) + "." + month(arg) + "." + day(arg) + " " + hour(arg) + ":" + minute(arg) + ":" + second(arg);
  return s;
}

//--------------------------------------------------------------------------------
//@private members
//--------------------------------------------------------------------------------

