// $License: NOLICENSE
//--------------------------------------------------------------------------------
/**
  Функции по работе с бланками переключений

  @file $relPath
  @copyright $copyright
  @author SMS-Automation
*/

//--------------------------------------------------------------------------------
// Libraries used (#uses)

#uses "Technodoc/Common/technodocNet"
#uses "Technodoc/Core/technodocServerSettings"
#uses "Technodoc/Core/technodocAuthorization"

//--------------------------------------------------------------------------------
// Variables and Constants


//--------------------------------------------------------------------------------
//@public members
//--------------------------------------------------------------------------------

/** Вернуть список тегов запрещенных для записи
  @return Список тегов запрещенных для записи
*/
dyn_string getOpenSwitchoverFormWriteForbiddenTagAddresses()
{
  string response = getOpenSwitchoverFormDescription();
  dyn_string responseArray = strsplit(response, "\n");
  dyn_string tagStrings;

  for (int i = 1; i < dynlen(responseArray) + 1; i++)
  {
    string el = responseArray[i];
    if (el[0] !=  35)
    {
      dynAppend(tagStrings, el);
    }
  }

  dyn_string result;
  for (int j = 1; j < dynlen(tagStrings) + 1; j++)
  {
    dyn_string ar = strsplit(tagStrings[j], ";");
    dynAppend(result, ar);
  }
  return result;
}

/** Вернуть описание открытого бланка переключения
  @return Описание открытого бланка переключения
*/
string getOpenSwitchoverFormDescription()
{
  string activeServerUrl = getActiveServerUrl();
  string url = activeServerUrl + "/api/SwitchoverForm/GetOpenFormDescription";
  string token = getAccessToken(activeServerUrl, TECHNODOC_DEFAULT_USER_LOGIN, TECHNODOC_DEFAULT_USER_PASSWORD);

  mapping response;
  mapping headers = makeMapping("Content-Type","application/json; charset=utf-8",
                                "Authorization", "Bearer " + token);
  mapping data = makeMapping("headers", headers);

  int result = technodocNetGet(url, response, data);

  if (result != 0) {
    DebugTN("Не удалось получить описание открытого бланка в ПО \"ТехноДок\"."
           + " Код состояния: " + response["httpStatusCode"] + ": " + response["httpStatusText"] + "."
           + " Подробности: " + response["errorString"]);
    return "";
  }
  else {
    return response.content;
  }
}

//--------------------------------------------------------------------------------
//@private members
//--------------------------------------------------------------------------------

