/*!
 * @license
 * chartjs-plugin-zoom
 * http://chartjs.org/
 * Version: 0.7.3
 *
 * Copyright 2019 Chart.js Contributors
 * Released under the MIT license
 * https://github.com/chartjs/chartjs-plugin-zoom/blob/master/LICENSE.md
 */
!function(e,o){"object"==typeof exports&&"undefined"!=typeof module?module.exports=o(require("chart.js"),require("hammerjs")):"function"==typeof define&&define.amd?define(["chart.js","hammerjs"],o):(e=e||self).ChartZoom=o(e.Chart,e.Hammer)}(this,function(e,o){"use strict";e=e&&e.hasOwnProperty("default")?e.default:e,o=o&&o.hasOwnProperty("default")?o.default:o;var n=e.helpers,t=e.Zoom=e.Zoom||{},a=t.zoomFunctions=t.zoomFunctions||{},i=t.panFunctions=t.panFunctions||{};function m(e,o){var t={};void 0!==e.options.pan&&(t.pan=e.options.pan),void 0!==e.options.pan&&(t.zoom=e.options.zoom);var a=e.$zoom;o=a._options=n.merge({},[o,t]);var i=a._node,m=o.zoom&&o.zoom.enabled,r=o.zoom.drag;m&&!r?i.addEventListener("wheel",a._wheelHandler):i.removeEventListener("wheel",a._wheelHandler),m&&r?(i.addEventListener("mousedown",a._mouseDownHandler),i.ownerDocument.addEventListener("mouseup",a._mouseUpHandler)):(i.removeEventListener("mousedown",a._mouseDownHandler),i.removeEventListener("mousemove",a._mouseMoveHandler),i.ownerDocument.removeEventListener("mouseup",a._mouseUpHandler))}function r(e){var o=e.$zoom._originalOptions;n.each(e.scales,function(e){o[e.id]||(o[e.id]=n.clone(e.options))}),n.each(o,function(n,t){e.scales[t]||delete o[t]})}function l(e,o){return void 0===e||"string"==typeof e&&-1!==e.indexOf(o)}function s(e,o){if(e.scaleAxes&&e.rangeMax&&!n.isNullOrUndef(e.rangeMax[e.scaleAxes])){var t=e.rangeMax[e.scaleAxes];o>t&&(o=t)}return o}function c(e,o){if(e.scaleAxes&&e.rangeMin&&!n.isNullOrUndef(e.rangeMin[e.scaleAxes])){var t=e.rangeMin[e.scaleAxes];o<t&&(o=t)}return o}function u(e,o,n,t){var a=e.max-e.min,i=a*(o-1),m=e.isHorizontal()?n.x:n.y,r=(e.getValueForPixel(m)-e.min)/a,l=i*r,u=i*(1-r);e.options.ticks.min=c(t,e.min+l),e.options.ticks.max=s(t,e.max-u)}function d(e,o,n,t){var i=a[e.type];i&&i(e,o,n,t)}function p(e,o,t,a,i){var m=e.chartArea;a||(a={x:(m.left+m.right)/2,y:(m.top+m.bottom)/2});var s=e.$zoom._options.zoom;if(s.enabled){r(e);var c,u=s.mode;c="xy"===u&&void 0!==i?i:"xy",n.each(e.scales,function(e){e.isHorizontal()&&l(u,"x")&&l(c,"x")?(s.scaleAxes="x",d(e,o,a,s)):!e.isHorizontal()&&l(u,"y")&&l(c,"y")&&(s.scaleAxes="y",d(e,t,a,s))}),e.update(0),"function"==typeof s.onZoom&&s.onZoom({chart:e})}}function v(e,o,t){var a,i=e.options.ticks,m=e.min,r=e.max,l=e.getValueForPixel(e.getPixelForValue(m)-o),s=e.getValueForPixel(e.getPixelForValue(r)-o),c=l=l.valueOf?l.valueOf():l,u=s=s.valueOf?s.valueOf():s;t.scaleAxes&&t.rangeMin&&!n.isNullOrUndef(t.rangeMin[t.scaleAxes])&&(c=t.rangeMin[t.scaleAxes]),t.scaleAxes&&t.rangeMax&&!n.isNullOrUndef(t.rangeMax[t.scaleAxes])&&(u=t.rangeMax[t.scaleAxes]),l>=c&&s<=u?(i.min=l,i.max=s):l<c?(a=m-c,i.min=c,i.max=r-a):s>u&&(a=u-r,i.max=u,i.min=m+a)}function f(e,o,n){var t=i[e.type];t&&t(e,o,n)}e.Zoom.defaults=e.defaults.global.plugins.zoom={pan:{enabled:!1,mode:"xy",speed:20,threshold:10},zoom:{enabled:!1,mode:"xy",sensitivity:3,speed:.1}},t.zoomFunctions.category=function(e,o,n,a){var i=e.chart.data.labels,m=e.minIndex,r=i.length-1,l=e.maxIndex,u=a.sensitivity,d=e.isHorizontal()?e.left+e.width/2:e.top+e.height/2,p=e.isHorizontal()?n.x:n.y;t.zoomCumulativeDelta=o>1?t.zoomCumulativeDelta+1:t.zoomCumulativeDelta-1,Math.abs(t.zoomCumulativeDelta)>u&&(t.zoomCumulativeDelta<0?(p>=d?m<=0?l=Math.min(r,l+1):m=Math.max(0,m-1):p<d&&(l>=r?m=Math.max(0,m-1):l=Math.min(r,l+1)),t.zoomCumulativeDelta=0):t.zoomCumulativeDelta>0&&(p>=d?m=m<l?m=Math.min(l,m+1):m:p<d&&(l=l>m?l=Math.max(m,l-1):l),t.zoomCumulativeDelta=0),e.options.ticks.min=c(a,i[m]),e.options.ticks.max=s(a,i[l]))},t.zoomFunctions.time=function(e,o,n,t){u(e,o,n,t),e.options.time.min=e.options.ticks.min,e.options.time.max=e.options.ticks.max},t.zoomFunctions.linear=u,t.zoomFunctions.logarithmic=u,t.panFunctions.category=function(e,o,n){var a,i=e.chart.data.labels,m=i.length-1,r=Math.max(e.ticks.length,1),l=n.speed,u=e.minIndex,d=Math.round(e.width/(r*l));t.panCumulativeDelta+=o,u=t.panCumulativeDelta>d?Math.max(0,u-1):t.panCumulativeDelta<-d?Math.min(m-r+1,u+1):u,t.panCumulativeDelta=u!==e.minIndex?0:t.panCumulativeDelta,a=Math.min(m,u+r-1),e.options.ticks.min=c(n,i[u]),e.options.ticks.max=s(n,i[a])},t.panFunctions.time=function(e,o,n){v(e,o,n);var t=e.options;t.time.min=t.ticks.min,t.time.max=t.ticks.max},t.panFunctions.linear=v,t.panFunctions.logarithmic=v,t.panCumulativeDelta=0,t.zoomCumulativeDelta=0;var h={id:"zoom",afterInit:function(e){e.resetZoom=function(){r(e);var o=e.$zoom._originalOptions;n.each(e.scales,function(e){var n=e.options.time,t=e.options.ticks;o[e.id]?(n&&(n.min=o[e.id].time.min,n.max=o[e.id].time.max),t&&(t.min=o[e.id].ticks.min,t.max=o[e.id].ticks.max)):(n&&(delete n.min,delete n.max),t&&(delete t.min,delete t.max))}),e.update()}},beforeUpdate:function(e,o){m(e,o)},beforeInit:function(e,a){e.$zoom={_originalOptions:{}};var i=e.$zoom._node=e.chart.ctx.canvas;m(e,a);var s=e.$zoom._options,c=s.pan&&s.pan.threshold;e.$zoom._mouseDownHandler=function(o){i.addEventListener("mousemove",e.$zoom._mouseMoveHandler),e.$zoom._dragZoomStart=o},e.$zoom._mouseMoveHandler=function(o){e.$zoom._dragZoomStart&&(e.$zoom._dragZoomEnd=o,e.update(0))},e.$zoom._mouseUpHandler=function(o){if(e.$zoom._dragZoomStart){i.removeEventListener("mousemove",e.$zoom._mouseMoveHandler);var n=e.$zoom._dragZoomStart,t=n.target.getBoundingClientRect().left,a=Math.min(n.clientX,o.clientX)-t,m=Math.max(n.clientX,o.clientX)-t,r=n.target.getBoundingClientRect().top,s=Math.min(n.clientY,o.clientY)-r,c=m-a,u=Math.max(n.clientY,o.clientY)-r-s;if(e.$zoom._dragZoomStart=null,e.$zoom._dragZoomEnd=null,!(c<=0&&u<=0)){var d=e.chartArea,v=e.$zoom._options.zoom,f=d.right-d.left,h=l(v.mode,"x")&&c?1+(f-c)/f:1,x=d.bottom-d.top,g=l(v.mode,"y");p(e,h,g&&u?1+(x-u)/x:1,{x:(a-d.left)/(1-c/f)+d.left,y:(s-d.top)/(1-u/x)+d.top}),"function"==typeof v.onZoomComplete&&v.onZoomComplete({chart:e})}}};var u=null;if(e.$zoom._wheelHandler=function(o){var n=o.target.getBoundingClientRect(),t={x:o.clientX-n.left,y:o.clientY-n.top},a=e.$zoom._options.zoom,i=a.speed;o.deltaY>=0&&(i=-i),p(e,1+i,1+i,t),clearTimeout(u),u=setTimeout(function(){"function"==typeof a.onZoomComplete&&a.onZoomComplete({chart:e})},250),o.cancelable&&o.preventDefault()},o){var d,v=new o.Manager(i);v.add(new o.Pinch),v.add(new o.Pan({threshold:c}));var h=function(o){var n=1/d*o.scale,t=o.target.getBoundingClientRect(),a={x:o.center.x-t.left,y:o.center.y-t.top},i=Math.abs(o.pointers[0].clientX-o.pointers[1].clientX),m=Math.abs(o.pointers[0].clientY-o.pointers[1].clientY),r=i/m;p(e,n,n,a,r>.3&&r<1.7?"xy":i>m?"x":"y"),d=o.scale};v.on("pinchstart",function(){d=1}),v.on("pinch",h),v.on("pinchend",function(e){h(e),d=null,t.zoomCumulativeDelta=0});var x=null,g=null,z=!1,_=function(o){if(null!==x&&null!==g){z=!0;var t=o.deltaX-x,a=o.deltaY-g;x=o.deltaX,g=o.deltaY,function(e,o,t){r(e);var a=e.$zoom._options.pan;if(a.enabled){var i=a.mode;n.each(e.scales,function(e){e.isHorizontal()&&l(i,"x")&&0!==o?(a.scaleAxes="x",f(e,o,a)):!e.isHorizontal()&&l(i,"y")&&0!==t&&(a.scaleAxes="y",f(e,t,a))}),e.update(0),"function"==typeof a.onPan&&a.onPan({chart:e})}}(e,t,a)}};v.on("panstart",function(e){x=0,g=0,_(e)}),v.on("panmove",_),v.on("panend",function(){x=null,g=null,t.panCumulativeDelta=0,setTimeout(function(){z=!1},500);var o=e.$zoom._options.pan;"function"==typeof o.onPanComplete&&o.onPanComplete({chart:e})}),e.$zoom._ghostClickHandler=function(e){z&&e.cancelable&&(e.stopImmediatePropagation(),e.preventDefault())},i.addEventListener("click",e.$zoom._ghostClickHandler),e._mc=v}},beforeDatasetsDraw:function(e){var o=e.chart.ctx;if(e.$zoom._dragZoomEnd){var n=function(e){for(var o=e.scales,n=Object.keys(o),t=0;t<n.length;t++){var a=o[n[t]];if(a.isHorizontal())return a}}(e),t=function(e){for(var o=e.scales,n=Object.keys(o),t=0;t<n.length;t++){var a=o[n[t]];if(!a.isHorizontal())return a}}(e),a=e.$zoom._dragZoomStart,i=e.$zoom._dragZoomEnd,m=n.left,r=n.right,s=t.top,c=t.bottom;if(l(e.$zoom._options.zoom.mode,"x")){var u=a.target.getBoundingClientRect().left;m=Math.min(a.clientX,i.clientX)-u,r=Math.max(a.clientX,i.clientX)-u}if(l(e.$zoom._options.zoom.mode,"y")){var d=a.target.getBoundingClientRect().top;s=Math.min(a.clientY,i.clientY)-d,c=Math.max(a.clientY,i.clientY)-d}var p=r-m,v=c-s,f=e.$zoom._options.zoom.drag;o.save(),o.beginPath(),o.fillStyle=f.backgroundColor||"rgba(225,225,225,0.3)",o.fillRect(m,s,p,v),f.borderWidth>0&&(o.lineWidth=f.borderWidth,o.strokeStyle=f.borderColor||"rgba(225,225,225)",o.strokeRect(m,s,p,v)),o.restore()}},destroy:function(e){if(e.$zoom){var o=e.$zoom,n=o._node;n.removeEventListener("mousedown",o._mouseDownHandler),n.removeEventListener("mousemove",o._mouseMoveHandler),n.ownerDocument.removeEventListener("mouseup",o._mouseUpHandler),n.removeEventListener("wheel",o._wheelHandler),n.removeEventListener("click",o._ghostClickHandler),delete e.$zoom;var t=e._mc;t&&(t.remove("pinchstart"),t.remove("pinch"),t.remove("pinchend"),t.remove("panstart"),t.remove("pan"),t.remove("panend"))}}};return e.plugins.register(h),h});
