var SysLogsChangesModalCtrl = (function () {
    function SysLogsChangesModalCtrl($scope, $modalInstance, language, notificationService, logChanges) {
        var _this = this;
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.language = language;
        this.notificationService = notificationService;
        this.logChanges = logChanges;
        this.changesTree = new SmsTree();
        this.changesTreeTypes = {
            '#': {
                icon: 'hidden'
            },
            default: {
                icon: 'hidden'
            },
            before: {
                icon: 'fa fa-minus text-danger'
            },
            after: {
                icon: 'fa fa-plus text-success'
            }
        };
        $scope.ctrl = this;
        $.jstree.defaults.core.force_text = true;
        this.$scope.$on('jstreeReady', function (event, treeId) {
            _this.changesTree.element.jstree().open_all();
            _this.changesTree.element.on('dblclick', 'li.jstree-leaf > a', function (e) {
                e.stopPropagation();
                var $node = $(this).parents('li.tree').eq(0);
                navigator.clipboard.writeText($node.context.textContent);
                notificationService.showMessage(language.getElementValue('copiedHnt'));
            });
        });
    }
    SysLogsChangesModalCtrl.prototype.openAll = function () {
        this.changesTree.element.jstree().open_all();
    };
    SysLogsChangesModalCtrl.prototype.closeAll = function () {
        this.changesTree.element.jstree().close_all();
    };
    SysLogsChangesModalCtrl.prototype.close = function () {
        this.$modalInstance.close();
    };
    SysLogsChangesModalCtrl.prototype.needShowChanges = function () {
        return this.logChanges.length !== 1
            && this.logChanges[0].id !== dto.differencesLimitExceededId;
    };
    SysLogsChangesModalCtrl.prototype.$onDestroy = function () {
        $.jstree.defaults.core.force_text = false;
    };
    SysLogsChangesModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        'language',
        'notificationService',
        'logChanges'
    ];
    return SysLogsChangesModalCtrl;
}());
angular.module('kamhpp').controller('sysLogsChangesModalCtrl', SysLogsChangesModalCtrl);
