var CimDictionaryInstance = (function () {
    function CimDictionaryInstance(scope, clientSettings, http, q, exportService) {
        var _this = this;
        this.clientSettings = clientSettings;
        this.http = http;
        this.q = q;
        this.exportService = exportService;
        this.watchFunctions = [];
        this.http = http;
        this.clientSettings = clientSettings;
        this.parentScope = scope;
        this.instances = [];
        this.files = undefined;
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return _this.instances.selected;
        }, function (after) {
            if (after == undefined)
                return;
            _this.parentScope.refresh(after.Id);
        }));
    }
    CimDictionaryInstance.prototype.loadDictionaryInstance = function () {
        var deferred = this.q.defer();
        this.http.get(this.clientSettings.getServerInstance() + '/CimModel/GetModels').then(function (response) {
            deferred.resolve(response.data);
        }, function (response) {
            deferred.reject(response);
        });
        return deferred.promise;
    };
    CimDictionaryInstance.prototype.exportDictionaryInstance = function (id) {
        this.exportService.export('/CimModel/ExportDictionaryInstance?id=' + id);
    };
    CimDictionaryInstance.prototype.destroy = function () {
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
        this.parentScope = undefined;
    };
    return CimDictionaryInstance;
}());
