var UserReport = (function () {
    function UserReport(defaultPageName, report) {
        this.defaultPageName = defaultPageName;
        if (_.isDefined(report)) {
            this.Id = report.Id;
            this.TemplateId = report.TemplateId;
            this.Name = report.Name;
            this.UpdatedDate = report.UpdatedDate;
            this.CreatedDate = report.CreatedDate;
            this.CreatedUserName = report.CreatedUserName;
            this.Period = report.Period;
            this.PeriodStep = report.PeriodStep;
            this.StartTime = report.StartTime;
            this.EndTime = report.EndTime;
            this.Signed = report.Signed;
            this.IsLocked = report.IsLocked;
            this.CalculationResult = report.CalculationResult;
            this.PredefinedValues = report.PredefinedValues;
            this.RecalculationState = report.RecalculationState;
            this.Values = report.Values;
            this.Changes = report.Changes;
            this.Rules = report.Rules;
            this.Html = report.Html;
            this.ContentVersion = report.ContentVersion;
            this.TemplateUniqueGuid = report.TemplateUniqueGuid;
            this.ExportFileNameTemplate = report.ExportFileNameTemplate;
            this.BinaryValues = report.BinaryValues;
            this.Errors = report.Errors;
        }
    }
    Object.defineProperty(UserReport.prototype, "Html", {
        get: function () {
            return this._html;
        },
        set: function (value) {
            this._html = value;
            this.setPages(value);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(UserReport.prototype, "pages", {
        get: function () {
            return this._pages;
        },
        enumerable: false,
        configurable: true
    });
    UserReport.prototype.setPages = function (html) {
        var reportPages = [];
        var divElement = document.createElement('div');
        divElement.innerHTML = html.trim();
        var htmlWithoutReportTag = '';
        _.forEach(divElement.children, function (element, index) {
            if (element.tagName.contains(ReportPageSettings.pageTag.toUpperCase()) &&
                element.hasAttribute(ReportPageSettings.pageAttribute)) {
                reportPages.push(new ReportPage(ReportPageSettings.createFrom(element), element.outerHTML, index));
            }
            else {
                htmlWithoutReportTag += element.outerHTML;
            }
        });
        if (!_.isEmpty(htmlWithoutReportTag)) {
            reportPages.push(new ReportPage(new ReportPageSettings(this.defaultPageName), htmlWithoutReportTag, reportPages.length));
        }
        this._pages = reportPages;
    };
    return UserReport;
}());
var PredefinedValuesInfo = (function () {
    function PredefinedValuesInfo(hashcode, values) {
        this.HashCode = hashcode;
        this.ParameterValues = values;
    }
    return PredefinedValuesInfo;
}());
var UserReportKey = (function () {
    function UserReportKey(id, templateId, interval, predefinedValuesHashCode) {
        this.id = id;
        this.templateId = templateId;
        this.interval = interval;
        this.predefinedValuesHashCode = predefinedValuesHashCode;
    }
    return UserReportKey;
}());
var UserReportShortInfo = (function () {
    function UserReportShortInfo(templateId, id, name, interval, predefinedValuesInfo) {
        this.templateId = templateId;
        this.id = id;
        this.name = name;
        this.interval = interval;
        this.predefinedValuesInfo = predefinedValuesInfo;
    }
    return UserReportShortInfo;
}());
var ReportTreePoint = (function () {
    function ReportTreePoint() {
    }
    return ReportTreePoint;
}());
var ReportShortInfo = (function () {
    function ReportShortInfo() {
    }
    return ReportShortInfo;
}());
var ReportValueError = (function () {
    function ReportValueError() {
    }
    return ReportValueError;
}());
var ReportValue = (function () {
    function ReportValue() {
        var _this = this;
        this.markWithoutErrors = function () {
            _this.error = null;
            _this.isDefined = true;
        };
    }
    return ReportValue;
}());
var StoryExceptionInfo = (function () {
    function StoryExceptionInfo() {
    }
    return StoryExceptionInfo;
}());
var ReportChange = (function () {
    function ReportChange() {
    }
    return ReportChange;
}());
