var OpcServersExplorerModalCtrl = (function () {
    function OpcServersExplorerModalCtrl(scope, modal, opcServiceProvider, language, notificationService, opcStandard) {
        this.scope = scope;
        this.modal = modal;
        this.opcServiceProvider = opcServiceProvider;
        this.language = language;
        this.notificationService = notificationService;
        this.opcStandard = opcStandard;
        this.host = '';
        this.endpoint = '';
        this.opcServers = [];
        this.selectedServer = null;
        this.searchResultMsg = '';
        this.scope.ctrl = this;
        this.host = 'localhost';
        this.endpoint = 'opc.tcp://localhost:4840';
        this.search();
    }
    OpcServersExplorerModalCtrl.prototype.search = function () {
        var _this = this;
        this.searchResultMsg = '';
        this.selectedServer = null;
        if (this.opcStandard === 2) {
            this.opcServiceProvider
                .getOpcUaServers(this.endpoint)
                .then(function (data) {
                var servers = _.groupBy(data, function (server) { return server.endpoint; });
                _this.processSuccessSearchResult(servers);
            })
                .catch(function (error) {
                _this.processErrorSearchResult(error);
            });
        }
        else {
            this.opcServiceProvider
                .getOpcDaHdaServers(this.host, this.opcStandard)
                .then(function (data) {
                _this.processSuccessSearchResult(data);
            })
                .catch(function (error) {
                _this.processErrorSearchResult(error);
            });
        }
    };
    OpcServersExplorerModalCtrl.prototype.getOpcDaHdaServerName = function (opcServerConnectionSettings) {
        return opcServerConnectionSettings.path;
    };
    OpcServersExplorerModalCtrl.prototype.getOpcUaServerName = function (opcServerConnectionSettings) {
        return (this.language.getElementValue('opcUaSecurityModeHdr') +
            ': ' +
            this.getDisplaySecurityMode(opcServerConnectionSettings.securityMode) +
            ', ' +
            this.language.getElementValue('opcUaSecurityPolicyHdr') +
            ': ' +
            this.getSecurityPolicy(opcServerConnectionSettings.securityPolicy));
    };
    OpcServersExplorerModalCtrl.prototype.isOpcUaStandard = function () {
        return this.opcStandard === 2;
    };
    OpcServersExplorerModalCtrl.prototype.ok = function () {
        this.modal.close(this.selectedServer);
    };
    OpcServersExplorerModalCtrl.prototype.cancel = function () {
        this.modal.dismiss();
    };
    OpcServersExplorerModalCtrl.prototype.getDisplaySecurityMode = function (securityMode) {
        switch (securityMode) {
            case 0: {
                return this.language.getElementValue('opcUaWithoutSecurityModeHdr');
            }
            case 1: {
                return this.language.getElementValue('opcUaSignMessagesPolicyHdr');
            }
            case 2: {
                return this.language.getElementValue('opcUaSignMessagesAndEncryptPolicyHdr');
            }
            default: {
                return '';
            }
        }
    };
    OpcServersExplorerModalCtrl.prototype.getSecurityPolicy = function (securityPolicy) {
        switch (securityPolicy) {
            case 0: {
                return this.language.getElementValue('opcUaWithoutSecurityPolicyHdr');
            }
            case 4: {
                return 'Aes128_Sha256_RsaOaep';
            }
            case 5: {
                return 'Aes256_Sha256_RsaPss';
            }
            case 1: {
                return 'Basic128Rsa15';
            }
            case 2: {
                return 'Basic256';
            }
            case 3: {
                return 'Basic256Sha256';
            }
            default: {
                return '';
            }
        }
    };
    OpcServersExplorerModalCtrl.prototype.processSuccessSearchResult = function (servers) {
        if (servers === void 0) { servers = []; }
        this.opcServers = servers;
        this.searchResultMsg = !_.isEmpty(servers)
            ? this.language.getElementValue('opcServersListMsg')
            : this.language.getElementValue('opcServersNotFoundMsg');
    };
    OpcServersExplorerModalCtrl.prototype.processErrorSearchResult = function (error) {
        this.opcServers = [];
        this.searchResultMsg = this.language.getElementValue('opcServersNotFoundMsg');
        this.notificationService.errorMessage(this.language.getElementValue('failedLoadDataServerMsg'), error);
    };
    OpcServersExplorerModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        'opcConnectionProvider',
        'language',
        'notificationService',
        'opcStandard',
    ];
    return OpcServersExplorerModalCtrl;
}());
angular.module('kamhpp').controller('opcServersExplorerModalCtrl', OpcServersExplorerModalCtrl);
