var AddSwitchoverFormSwitchingInfoModalCtrl = (function () {
    function AddSwitchoverFormSwitchingInfoModalCtrl(scope, modal, language) {
        this.scope = scope;
        this.modal = modal;
        this.language = language;
        this.commands = [];
        this.scope.ctrl = this;
        this.commands = [
            {
                text: language.getElementValue('switchoverFormsSerialNumberHdr'),
                name: language.getElementValue('switchoverFormsAddSerialNumberHdr'),
            },
            {
                text: language.getElementValue('switchoverFormsPostDateOpenHdr'),
                name: language.getElementValue('switchoverFormsAddStartDateHdr'),
            },
            {
                text: language.getElementValue('switchoverFormsPostDateCloseHdr'),
                name: language.getElementValue('switchoverFormsAddCloseDateHdr'),
            },
            {
                text: language.getElementValue('switchoverFormsPostChangesHdr'),
                name: language.getElementValue('switchoverFormsAddPerpetratorHdr'),
            },
            {
                text: language.getElementValue('switchoverFormsPostControlHdr'),
                name: language.getElementValue('switchoverFormsAddControllerHdr'),
            },
            {
                text: language.getElementValue('switchoverFormsPostResolveHdr'),
                name: language.getElementValue('switchoverFormsAddApproverHdr'),
            },
        ];
        this.addPostCommand = {
            text: String.Format(language.getElementValue('switchoverFormsPostWithPersonNameHdr'), ''),
            name: language.getElementValue('switchoverFormsAddNewPersonHdr'),
        };
        this.commands.push(this.addPostCommand);
        this.selectedCommand = this.commands[0];
    }
    AddSwitchoverFormSwitchingInfoModalCtrl.prototype.selectCommand = function (command) {
        this.selectedCommand = command;
    };
    AddSwitchoverFormSwitchingInfoModalCtrl.prototype.onPostNameChange = function () {
        this.selectedCommand.text = String.Format(this.language.getElementValue('switchoverFormsPostWithPersonNameHdr'), this.postName);
    };
    AddSwitchoverFormSwitchingInfoModalCtrl.prototype.ok = function () {
        this.modal.close(this.selectedCommand.text);
    };
    AddSwitchoverFormSwitchingInfoModalCtrl.prototype.cancel = function () {
        this.modal.dismiss();
    };
    AddSwitchoverFormSwitchingInfoModalCtrl.$inject = ['$scope', '$modalInstance', 'language'];
    return AddSwitchoverFormSwitchingInfoModalCtrl;
}());
angular.module('kamhpp').controller('addSwitchoverFormSwitchingInfoModalCtrl', AddSwitchoverFormSwitchingInfoModalCtrl);
