var EditTemplateAlarmsModalCtrl = (function () {
    function EditTemplateAlarmsModalCtrl(scope, modal, language, templateId, templateAlarms, alarms) {
        var _this = this;
        this.scope = scope;
        this.modal = modal;
        this.language = language;
        this.nameTextFilter = '';
        this.commandTextFilter = '';
        this.scope.ctrl = this;
        this.templateId = templateId;
        this.templateAlarms = templateAlarms;
        var templateAlarmsIds = _.map(templateAlarms, function (a) { return a.switchoverFormCommonAlarmId; });
        var enabledAlarms = _.filter(alarms, function (alarm) { return _.include(templateAlarmsIds, alarm.id); });
        var disabledAlarms = _.filter(alarms, function (alarm) { return !_.include(templateAlarmsIds, alarm.id); });
        var sortedAlarms = _.sortBy(enabledAlarms, function (a) { return a.name; }).concat(_.sortBy(disabledAlarms, function (a) { return a.name; }));
        this.alarms = _.map(sortedAlarms, function (a) { return new Alarm(a, _this.language.getElementValue('opcSourceHdr'), _this.language.getElementValue('winccoaHdr')); });
    }
    EditTemplateAlarmsModalCtrl.prototype.ok = function () {
        this.modal.close(this.templateAlarms);
    };
    EditTemplateAlarmsModalCtrl.prototype.cancel = function () {
        this.modal.dismiss();
    };
    EditTemplateAlarmsModalCtrl.prototype.hasAlarm = function (alarm) {
        return _.any(this.templateAlarms, function (templateAlarm) { return templateAlarm.switchoverFormCommonAlarmId === alarm.id; });
    };
    EditTemplateAlarmsModalCtrl.prototype.selectAlarm = function (alarm) {
        if (_.any(this.templateAlarms, function (templateAlarm) { return templateAlarm.switchoverFormCommonAlarmId === alarm.id; })) {
            this.templateAlarms = _.filter(this.templateAlarms, function (templateAlarm) { return templateAlarm.switchoverFormCommonAlarmId !== alarm.id; });
        }
        else {
            this.templateAlarms.push({
                switchoverFormTemplateId: this.templateId,
                switchoverFormCommonAlarmId: alarm.id,
            });
        }
    };
    EditTemplateAlarmsModalCtrl.$inject = ['$scope', '$modalInstance', 'language', 'templateId', 'templateAlarms', 'alarms'];
    return EditTemplateAlarmsModalCtrl;
}());
angular.module('kamhpp').controller('editTemplateAlarmsModalCtrl', EditTemplateAlarmsModalCtrl);
