var SwitchoverFormTemplateImportModalCtrl = (function () {
    function SwitchoverFormTemplateImportModalCtrl($scope, $modalInstance, languageService, $upload, clientSettings, notificationService, chapters) {
        var _this = this;
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.languageService = languageService;
        this.$upload = $upload;
        this.clientSettings = clientSettings;
        this.notificationService = notificationService;
        this.importFormats = [
            new UiSelectItem(6, 'DOCX'),
            new UiSelectItem(7, 'JSON'),
        ];
        this.templatesCanUpdate = [];
        this.importStatuses = [
            1,
            2,
        ];
        this.isAllTemplatesSelected = true;
        this.isNoneTemplatesSelected = false;
        this.watchFunctions = [];
        this.getOptionImportStatus = function (status) {
            switch (status) {
                case 1:
                    return _this.languageService.getElementValue('importStatusAddedHdr');
                case 2:
                    return _this.languageService.getElementValue('importStatusUpdatedHdr');
                default:
                    return _this.languageService.getElementValue('importStatusNonHdr');
            }
        };
        this.$scope.ctrl = this;
        this.selectedImportFormat = this.importFormats[0];
        this.importProvider = this.changeImportProvider(this.selectedImportFormat.ident);
        this.chapters = chapters;
        this.watchFunctions.push(this.$scope.$watch('ctrl.selectedImportFormat', function (after, before, $scope) {
            $scope.ctrl.importProvider = $scope.ctrl.changeImportProvider(after.ident);
        }));
        this.watchFunctions.push(this.$scope.$watch('ctrl.importProvider.files', function (after, before, $scope) {
            var _this = this;
            if (_.isUndefined(after) || after.length === 0) {
                return;
            }
            $scope.ctrl.$upload.upload($scope.ctrl.importProvider.getImportInfoForSelect()).then(function (response) {
                $scope.ctrl.templatesCanUpdate = [];
                $scope.ctrl.importProvider.importOptions = _.map(response.data, function (i) {
                    if (i.status === 2) {
                        $scope.ctrl.templatesCanUpdate.push(i);
                    }
                    return {
                        info: i,
                        isSelected: true,
                    };
                });
            }, function (data) {
                $scope.ctrl.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
            });
        }));
    }
    SwitchoverFormTemplateImportModalCtrl.prototype.changeAllTemplateOptionsStatus = function () {
        var currentStatus = this.isAllTemplatesSelected;
        _.forEach(this.importProvider.importOptions, function (t) {
            t.isSelected = !currentStatus;
        });
        this.isAllTemplatesSelected = !currentStatus;
        this.isNoneTemplatesSelected = currentStatus;
    };
    SwitchoverFormTemplateImportModalCtrl.prototype.changeOptionSelectStatus = function (option) {
        if (_.isDefined(option)) {
            option.isSelected = !option.isSelected;
        }
        this.isAllTemplatesSelected = _.all(this.importProvider.importOptions, function (t) { return t.isSelected; });
        this.isNoneTemplatesSelected = _.all(this.importProvider.importOptions, function (t) { return !t.isSelected; });
    };
    SwitchoverFormTemplateImportModalCtrl.prototype.isDocxFormatSelected = function () {
        return this.selectedImportFormat.ident === 6;
    };
    SwitchoverFormTemplateImportModalCtrl.prototype.isFilesSelected = function () {
        return !_.isUndefined(this.importProvider.files) && _.any(this.importProvider.files);
    };
    SwitchoverFormTemplateImportModalCtrl.prototype.canChangeStatus = function (info) {
        return _.contains(this.templatesCanUpdate, info);
    };
    SwitchoverFormTemplateImportModalCtrl.prototype.ok = function () {
        this.$modalInstance.close(this.importProvider.getImportInfoForImport());
    };
    SwitchoverFormTemplateImportModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    SwitchoverFormTemplateImportModalCtrl.prototype.changeImportProvider = function (format) {
        switch (format) {
            case 6:
                return new SwitchoverFormImportProviderDocx(this.clientSettings.getServerInstance(), '/SwitchoverFormTemplateImport/GetDocxImportInfo', '/SwitchoverFormTemplateImport/ImportFromDocx', true);
            case 7:
                return new SwitchoverFormImportProviderJson(this.clientSettings.getServerInstance(), '/SwitchoverFormTemplateImport/GetJsonImportInfo', '/SwitchoverFormTemplateImport/ImportFromJson', true);
            default:
                this.notificationService.errorMessage(String.Format(this.languageService.getElementValue('switchoverFormsUnknownImportFormatMsg'), format.toString()));
                break;
        }
    };
    SwitchoverFormTemplateImportModalCtrl.$inject = ['$scope', '$modalInstance', 'language', '$upload', 'clientSettings', 'notificationService', 'chapters',];
    return SwitchoverFormTemplateImportModalCtrl;
}());
angular.module('kamhpp').controller('switchoverFormTemplateImportModalCtrl', SwitchoverFormTemplateImportModalCtrl);
