var CopySwitchoverFormTemplateModalCtrl = (function () {
    function CopySwitchoverFormTemplateModalCtrl(scope, modal, switchoverFormTemplateProviderService, notificationService, language, templateName, operationNumber) {
        this.scope = scope;
        this.modal = modal;
        this.switchoverFormTemplateProviderService = switchoverFormTemplateProviderService;
        this.notificationService = notificationService;
        this.language = language;
        this.needStopCurrentForm = true;
        this.scope.ctrl = this;
        this.templateName = templateName;
        this.operationNumber = _.isUndefined(operationNumber) ? 1 : operationNumber;
    }
    CopySwitchoverFormTemplateModalCtrl.prototype.ok = function () {
        var _this = this;
        this.switchoverFormTemplateProviderService
            .isExists(this.templateName)
            .then(function (isTemplateExists) {
            if (isTemplateExists) {
                _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('switchoverFormsTemplateAlreadyExistsMsg'), _this.templateName));
            }
            else {
                _this.modal.close({
                    templateName: _this.templateName,
                    operationNumber: _this.operationNumber,
                    needStopCurrentForm: _this.needStopCurrentForm,
                });
            }
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    CopySwitchoverFormTemplateModalCtrl.prototype.onOperationNumberChange = function () {
        if (_.isUndefined(this.operationNumber) || this.operationNumber <= 0) {
            this.operationNumber = 1;
        }
    };
    CopySwitchoverFormTemplateModalCtrl.prototype.cancel = function () {
        this.modal.dismiss();
    };
    CopySwitchoverFormTemplateModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        'switchoverFormTemplateProvider',
        'notificationService',
        'language',
        'templateName',
        'operationNumber',
    ];
    return CopySwitchoverFormTemplateModalCtrl;
}());
angular.module('kamhpp').controller('copySwitchoverFormTemplateModalCtrl', CopySwitchoverFormTemplateModalCtrl);
