var CreateSwitchoverFormModalCtrl = (function () {
    function CreateSwitchoverFormModalCtrl(scope, modal, notificationService, language, users, appointments, serialNumber, preferredSigners) {
        var _this = this;
        this.scope = scope;
        this.modal = modal;
        this.notificationService = notificationService;
        this.language = language;
        this.users = users;
        this.appointments = appointments;
        this.serialNumber = serialNumber;
        this.preferredSigners = preferredSigners;
        this.signers = [];
        this.needVerifyConditions = true;
        this.getUserNames = function () {
            return;
        };
        this.scope.ctrl = this;
        this.userNames = _.map(this.users, function (u) { return u.name; });
        _.each(appointments, function (appointment) {
            var preferredSigner = _.find(preferredSigners, function (x) { return x.appointment === appointment; });
            var signer = _.isUndefined(preferredSigner)
                ? { appointment: appointment, fullName: '', position: '' }
                : { appointment: preferredSigner.appointment, fullName: preferredSigner.fullName, position: '' };
            _this.signers.push(signer);
        });
    }
    CreateSwitchoverFormModalCtrl.prototype.ok = function () {
        var _this = this;
        if (_.any(this.signers, function (signer) { return signer.fullName === ''; })) {
            this.notificationService.warnMessage(this.language.getElementValue('switchoverFormsAllNamesOfStaffMembersShouldBeFillInMsg'));
            return;
        }
        _.forEach(this.signers, function (signer) {
            var foundUser = _.find(_this.users, function (user) { return user.name === signer.fullName; });
            signer.position = _.isUndefined(foundUser) ? null : foundUser.position;
        });
        this.modal.close({
            signers: this.signers,
            serialNumber: this.serialNumber,
            needVerifyConditions: this.needVerifyConditions,
        });
    };
    CreateSwitchoverFormModalCtrl.prototype.onSerialNumberChange = function () {
        if (_.isUndefined(this.serialNumber) || this.serialNumber <= 0) {
            this.serialNumber = 1;
        }
    };
    CreateSwitchoverFormModalCtrl.prototype.cancel = function () {
        this.modal.dismiss();
    };
    CreateSwitchoverFormModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        'notificationService',
        'language',
        'users',
        'appointments',
        'serialNumber',
        'preferredSigners',
    ];
    return CreateSwitchoverFormModalCtrl;
}());
angular.module('kamhpp').controller('createSwitchoverFormModalCtrl', CreateSwitchoverFormModalCtrl);
