var ReportParameterDropdown = (function () {
    function ReportParameterDropdown() {
        this.variations = JSON.stringify(['1', '2', '3']);
        this.defaultValue = '1';
        this.defaultValueType = 0;
        this.initialParameter = '';
        this.canMultipleSelect = false;
        this.viewMode = 0;
        this.dictionarySettings = new DictionaryDropdown();
        this.anotherParameterSourceIdent = "";
        this.source = 0;
    }
    ReportParameterDropdown.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new ReportParameterDropdown();
        clone.variations = obj.variations;
        clone.defaultValue = obj.defaultValue;
        clone.defaultValueType = obj.defaultValueType;
        clone.initialParameter = obj.initialParameter;
        clone.canMultipleSelect = obj.canMultipleSelect;
        clone.viewMode = obj.viewMode;
        clone.source = obj.source;
        clone.anotherParameterSourceIdent = obj.anotherParameterSourceIdent;
        clone.dictionarySettings = DictionaryDropdown.clone(obj.dictionarySettings);
        return clone;
    };
    ReportParameterDropdown.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.variations === other.variations &&
            obj.defaultValue === other.defaultValue &&
            obj.defaultValueType === other.defaultValueType &&
            obj.initialParameter === other.initialParameter &&
            obj.canMultipleSelect === other.canMultipleSelect &&
            obj.viewMode === other.viewMode &&
            obj.source === other.source &&
            obj.anotherParameterSourceIdent === other.anotherParameterSourceIdent &&
            DictionaryDropdown.isEqual(obj.dictionarySettings, other.dictionarySettings));
    };
    ReportParameterDropdown.prototype.canEdited = function () {
        return false;
    };
    ReportParameterDropdown.prototype.canPlanned = function () {
        return true;
    };
    ReportParameterDropdown.prototype.canBacklight = function () {
        return false;
    };
    ReportParameterDropdown.prototype.canPredefined = function () {
        return true;
    };
    return ReportParameterDropdown;
}());
