var FileSettings = (function () {
    function FileSettings() {
        this.fileType = 3;
    }
    FileSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return obj.connectionGuid === other.connectionGuid
            && obj.fileType === other.fileType;
    };
    FileSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new FileSettings();
        clone.connectionGuid = obj.connectionGuid;
        clone.fileType = obj.fileType;
        return clone;
    };
    FileSettings.prototype.canEdited = function () {
        return true;
    };
    FileSettings.prototype.canPlanned = function () {
        return true;
    };
    FileSettings.prototype.canBacklight = function () {
        return false;
    };
    FileSettings.prototype.canPredefined = function () {
        return false;
    };
    return FileSettings;
}());
