var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var InfluxSettingsCtrl = (function (_super) {
    __extends(InfluxSettingsCtrl, _super);
    function InfluxSettingsCtrl(codeEditor, modalService, parentScope, language) {
        var _this = _super.call(this, codeEditor, modalService, parentScope) || this;
        _this.parentScope = parentScope;
        _this.language = language;
        _this.watchFunctions = [];
        _this.connectionTypes = [10];
        return _this;
    }
    InfluxSettingsCtrl.prototype.init = function () {
        var self = this;
        this.functions = getVariantsContainer(this.parentScope, [
            new SelectSourceFunctionsItem('tables', this.language.getElementValue('influxTablesHtmlHdr'), 'ReportTable[]'),
            new SelectSourceFunctionsItem('double[][][]', this.language.getElementValue('influxDoubleMatrixHtmlHdr'), 'double[][][]'),
            new SelectSourceFunctionsItem('cellString', this.language.getElementValue('reportCellStringHdr'), 'string'),
            new SelectSourceFunctionsItem('cellDouble', this.language.getElementValue('reportCellNumberHdr'), 'double'),
            new SelectSourceFunctionsItem('string[]', this.language.getElementValue('sqlStringSetHdr'), 'string[]'),
        ], function (t) {
            return t.ident === self.parentScope.param.Influx.func;
        }, function (after, before) {
            if (after == undefined || after === before) {
                return;
            }
            self.parentScope.param.Influx.func = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
            if (!self.canEdited()) {
                self.parentScope.param.Editable = false;
            }
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.parentScope.param.Influx;
        }, function (before, after) {
            if (_.isUndefined(self.parentScope.param.Influx) ||
                _.isNull(self.parentScope.param.Influx) ||
                after == undefined) {
                return;
            }
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        }, true));
        this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.functions.selected.returnType);
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    InfluxSettingsCtrl.prototype.onCodeEditorChange = function (change) {
        this.parentScope.param.Influx.sql = change.code;
    };
    InfluxSettingsCtrl.prototype.destroy = function () {
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    };
    InfluxSettingsCtrl.prototype.getFormula = function () {
        var params = '"' +
            this.parentScope.param.Influx.connectionGuid +
            '", ' +
            '"' +
            this.querryEditor(this.parentScope.param.Influx.sql) +
            '"';
        switch (this.functions.selected.ident) {
            case 'tables':
                return ('return InfluxQueryAsHtmlTablesByConnection(' +
                    params +
                    ', ' +
                    this.parentScope.param.Influx.includeHeader +
                    ');');
            case 'double[][][]':
                return 'return InfluxQueryAsDoubleArraysByConnection(' + params + ');';
            case 'cellString':
                return 'return InfluxQueryAsStringByConnection(' + params + ');';
            case 'cellDouble':
                return 'return InfluxQueryAsDoubleByConnection(' + params + ');';
            case 'string[]':
                return 'return InfluxQueryAsStringArraysByConnection(' + params + ')[0][0];';
        }
        return '';
    };
    InfluxSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    InfluxSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Influx.canEdited();
    };
    InfluxSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Influx.canPlanned();
    };
    InfluxSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Influx.canBacklight();
    };
    InfluxSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Influx.canPredefined();
    };
    InfluxSettingsCtrl.prototype.querryEditor = function (query) {
        if (!query) {
            return '';
        }
        var out = '';
        _.forEach(query.split(''), function (simb) {
            simb === '"' ? (out = out + '\\' + simb) : (out = out + simb);
        });
        return out;
    };
    return InfluxSettingsCtrl;
}(DatabaseSettingsBaseCtrl));
