app.controller('LogDropdownFieldSettingsModalCtrl', function ($scope, $modalInstance, field, language) {
    var defalultName = language.getElementValue('reportPossibleValueHdr');
    $scope.field = field;
    if (_.isUndefined($scope.field.additionalSettings) || _.isNull($scope.field.additionalSettings)) {
        $scope.field.additionalSettings = new Array();
    }
    $scope.variations = _.map($scope.field.additionalSettings, function (variation) {
        return new UiSelectItem(variation, variation);
    });
    $scope.addVariation = function () {
        var variation = defalultName + ' 1';
        var n = 0;
        while (_.any($scope.variations, function (i) {
            return i.name === variation;
        })) {
            n++;
            variation = defalultName + ' ' + (n + 1).toString();
        }
        $scope.variations.push(new UiSelectItem(variation, variation));
    };
    $scope.ok = function () {
        $scope.field.additionalSettings = _.map($scope.variations, function (variation) {
            return variation.name;
        });
        $modalInstance.close($scope.field);
    };
    $scope.cancel = function () {
        $modalInstance.dismiss('cancel');
    };
});
