var OperationTimeDiagramSettings = (function () {
    function OperationTimeDiagramSettings() {
        this.legendPosition = 0;
        this.width = 800;
    }
    OperationTimeDiagramSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new OperationTimeDiagramSettings();
        clone.parameterName = obj.parameterName;
        clone.startDate = obj.startDate;
        clone.endDate = obj.endDate;
        clone.title = obj.title;
        clone.width = obj.width;
        clone.legendPosition = obj.legendPosition;
        return clone;
    };
    OperationTimeDiagramSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.parameterName === other.parameterName &&
            obj.startDate === other.startDate &&
            obj.endDate === other.endDate &&
            obj.title === other.title &&
            obj.width === other.width &&
            obj.legendPosition === other.legendPosition);
    };
    OperationTimeDiagramSettings.prototype.canEdited = function () {
        return false;
    };
    OperationTimeDiagramSettings.prototype.canPlanned = function () {
        return true;
    };
    OperationTimeDiagramSettings.prototype.canBacklight = function () {
        return false;
    };
    OperationTimeDiagramSettings.prototype.canPredefined = function () {
        return false;
    };
    return OperationTimeDiagramSettings;
}());
