var ReportFormulaEscaper = (function () {
    function ReportFormulaEscaper() {
    }
    ReportFormulaEscaper.escape = function (value, parameters) {
        if (_.isUndefined(value) || _.isNull(value)) {
            return '"' + value + '"';
        }
        var parametersRegex = /(?<=%)[^%]*(?=%)/g;
        var parameterMatch;
        while ((parameterMatch = parametersRegex.exec(value)) !== null) {
            if (this.isReportParameter(parameterMatch[0], parameters)) {
                value = value.substring(0, parameterMatch.index - 1) +
                    '{%' + parameterMatch[0] + '%}' +
                    value.substring((parameterMatch.index + 1) + parameterMatch[0].length);
            }
        }
        return "$\"\"\"\n".concat(value, "\n\"\"\"");
    };
    ReportFormulaEscaper.isReportParameter = function (parameterIdent, parameters) {
        return _.any(parameters, function (parameter) { return parameter.Ident === parameterIdent; });
    };
    return ReportFormulaEscaper;
}());
