var ReportFormulasCtrl = (function () {
    function ReportFormulasCtrl($window, $rootScope, $scope, $modal, $location, $upload, $q, clientSettings, exportService, reportFormulasProvider, notificationService, language, reportCompletionsProvider) {
        var _this = this;
        this.$window = $window;
        this.$rootScope = $rootScope;
        this.$scope = $scope;
        this.$modal = $modal;
        this.$location = $location;
        this.$upload = $upload;
        this.$q = $q;
        this.clientSettings = clientSettings;
        this.exportService = exportService;
        this.reportFormulasProvider = reportFormulasProvider;
        this.notificationService = notificationService;
        this.language = language;
        this.reportCompletionsProvider = reportCompletionsProvider;
        this.resultTypes = [
            new UiSelectItem('double', this.language.getElementValue('reportParameterTypeDoubleHdr')),
            new UiSelectItem('double?', this.language.getElementValue('reportParameterTypeDoubleNullableHdr')),
            new UiSelectItem('int', this.language.getElementValue('reportParameterTypeIntegerHdr')),
            new UiSelectItem('string', this.language.getElementValue('reportParameterTypeStringHdr')),
            new UiSelectItem('DateTime', this.language.getElementValue('dateHdr')),
            new UiSelectItem('TimeSpan', this.language.getElementValue('reportParameterTypeTimeSpanHdr')),
            new UiSelectItem('ReportTable', this.language.getElementValue('reportParameterTypeTableHdr')),
            new UiSelectItem('ReportTable[]', this.language.getElementValue('reportParameterTypeTablesHdr')),
            new UiSelectItem('WinccOaAlarmsTable', this.language.getElementValue('reportParameterTypeWinccOaAlarmsTableHdr')),
            new UiSelectItem('JArray', this.language.getElementValue('reportParameterTypeArrayHdr')),
            new UiSelectItem('LogRow[]', this.language.getElementValue('reportParameterTypeLogDataHdr')),
            new UiSelectItem('WinccValue', this.language.getElementValue('reportParameterTypeValueWinCcHdr')),
            new UiSelectItem('WinccOaValue', this.language.getElementValue('reportParameterTypeValueWinCcOaHdr')),
            new UiSelectItem('AggregationValue', this.language.getElementValue('reportParameterTypeAggregationValueHdr')),
            new UiSelectItem('PiramidaValue', this.language.getElementValue('reportParameterTypePiramidaValueHdr')),
            new UiSelectItem('PiramidaDiscretState', this.language.getElementValue('reportParameterTypePiramidaDiscretStateHdr')),
            new UiSelectItem('OpcValue', this.language.getElementValue('reportParameterTypeValueOpcHdr')),
            new UiSelectItem('LinkValue', this.language.getElementValue('reportParameterNavigationHdr')),
            new UiSelectItem('WinccOaAlarm[]', this.language.getElementValue('reportParameterTypeListAlarmsWinCcHdr')),
            new UiSelectItem('XmlValue', this.language.getElementValue('reportParameterTypeXmlDocumentHdr')),
            new UiSelectItem('JsValue', this.language.getElementValue('reportParameterTypeJsValueHdr')),
            new UiSelectItem('ReportChartValue', this.language.getElementValue('reportParameterTypeReportChartValueHdr')),
            new UiSelectItem('DictionaryClassInstance[]', this.language.getElementValue('reportParameterTypeArrayCimModelClassesHdr')),
            new UiSelectItem('double[]', this.language.getElementValue('reportParameterTypeArrayDoubleHdr')),
            new UiSelectItem('double[][]', this.language.getElementValue('reportParameterTypeTableDoubleHdr')),
            new UiSelectItem('double[][][]', this.language.getElementValue('reportParameterTypeTablesDoubleHdr')),
            new UiSelectItem('int[]', this.language.getElementValue('reportParameterTypeArrayIntHdr')),
            new UiSelectItem('int[][]', this.language.getElementValue('reportParameterTypeTableIntHdr')),
            new UiSelectItem('string[]', this.language.getElementValue('reportParameterTypeArrayStringHdr')),
            new UiSelectItem('string[][]', this.language.getElementValue('reportParameterTypeTableStringHdr')),
            new UiSelectItem('string[][][]', this.language.getElementValue('reportParameterTypeTablesStringHdr')),
            new UiSelectItem('object[]', this.language.getElementValue('reportParameterTypeArrayObjectHdr')),
            new UiSelectItem('object[][]', this.language.getElementValue('reportParameterTypeTableObjectHdr')),
            new UiSelectItem('Boolean', this.language.getElementValue('reportParameterTypeBoolHdr')),
            new UiSelectItem('WinccValue[]', this.language.getElementValue('reportParameterTypeWinCcValueTableHdr')),
            new UiSelectItem('OperationTimeParameterLog', this.language.getElementValue('reportParameterTypeOTDeviceLogArrayHdr')),
            new UiSelectItem('StoredReportValue', this.language.getElementValue('reportParameterTypeStoredReportValueHdr')),
            new UiSelectItem('StoredReportValue[]', this.language.getElementValue('reportParameterTypeStoredReportValueArrayHdr')),
            new UiSelectItem('DropDownValue', this.language.getElementValue('reportParameterTypeDropDownListHdr')),
            new UiSelectItem(UserFileSettings.UserFileReturnValueTypeName, this.language.getElementValue('reportParameterTypeFileValueHdr'))
        ];
        this.uniqueNamePattern = this.language.getElementValue('reportFormulaUniqueNamePattern');
        this.formulas = [];
        this.isParametersSidebarOpened = true;
        this.parameterFilter = '';
        this.containerForFile = { data: {} };
        this.watchFunctions = [];
        this.filterParameters = function (parameter) {
            var _a;
            if ((_a = parameter.name) === null || _a === void 0 ? void 0 : _a.toLowerCase().includes(_this.parameterFilter.toLowerCase())) {
                return parameter;
            }
        };
    }
    ReportFormulasCtrl.prototype.$onInit = function () {
        var _this = this;
        this.reportFormulasProvider.getAll().then(function (formulas) {
            _this.formulas = formulas;
            var searchParams = _this.$location.search();
            var selectedFormula = _.isDefined(searchParams.id)
                ? _.find(formulas, function (formula) { return formula.id == searchParams.id; })
                : _.first(formulas);
            _this.selectFormula(selectedFormula);
        }, function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error); });
        this.reportCompletionsProvider.getCompletions()
            .then(function (completions) { return _this.completions = completions; })
            .catch(function (error) {
            _this.completions = [];
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
        this.$window.onbeforeunload = function (event) {
            var message = undefined;
            if (_.isDefined(_this.selectedFormula) && _this.selectedFormula.isChanged) {
                message = _this.language.getElementValue('changesNoSaveMsg');
            }
            if (typeof event == 'undefined') {
                event = window.event;
            }
            if (_.isDefined(event) && _.isDefined(message)) {
                event.returnValue = message;
                return message;
            }
            return undefined;
        };
        this.watchFunctions.push(this.$rootScope.$on('$locationChangeStart', function (event) {
            if (_.isUndefined(_this.selectedFormula)
                || !_this.selectedFormula.isChanged) {
                return;
            }
            var newUrl = _this.$location.url();
            event.preventDefault();
            _this.saveFormula().then(function () {
                _this.setNewSelected(undefined);
                _this.$location.url(newUrl);
            });
        }));
        this.watchFunctions.push(this.$scope.$watch(function () {
            return _this.containerForFile.data;
        }, function () {
            if (_.isUndefined(_this.containerForFile.data)
                || !_.any(_this.containerForFile.data))
                return;
            _this.$upload.upload({
                url: _this.clientSettings.getServerInstance() + '/ReportFormulas/Import',
                file: _this.containerForFile.data
            }).then(function (importedFormulassResponse) {
                if (!_.any(importedFormulassResponse.data)) {
                    return;
                }
                _.each(importedFormulassResponse.data, function (imported) {
                    var existedIdx = _.findIndex(_this.formulas, function (existedFormula) {
                        return existedFormula.id === imported.id;
                    });
                    if (existedIdx > -1) {
                        _this.formulas[existedIdx] = imported;
                        if (_this.selectedFormula.id === imported.id) {
                            _this.selectedFormula
                                = new ReportFormula(_this.formulas[existedIdx]);
                        }
                    }
                    else {
                        _this.formulas.push(imported);
                    }
                });
                if (_.isUndefined(_this.selectedFormula) && _.any(_this.formulas)) {
                    _this.selectedFormula
                        = new ReportFormula(_this.formulas[0]);
                }
                _this.notificationService.showMessage(_this.language.getElementValue('importReportFormulasSuccessMsg'));
            }, function (data) {
                _this.notificationService.errorMessage(_this.language.getElementValue('importReportFormulasErrorMsg'), data);
            });
        }));
    };
    ReportFormulasCtrl.prototype.$onDestroy = function () {
        _.forEach(this.watchFunctions, function (func) {
            if (func) {
                func();
            }
        });
    };
    ReportFormulasCtrl.prototype.hasFormulas = function () {
        return _.any(this.formulas);
    };
    ReportFormulasCtrl.prototype.isSelected = function (formula) {
        var _a;
        return _.isDefined((_a = this.selectedFormula) === null || _a === void 0 ? void 0 : _a.id) && this.selectedFormula.id === formula.id;
    };
    ReportFormulasCtrl.prototype.onCodeEditorInitialized = function (codeEditor) {
        this.codeEditor = codeEditor;
        this.codeEditor.focus();
    };
    ReportFormulasCtrl.prototype.onCodeEditorChange = function (change) {
        var _this = this;
        if (_.isUndefined(this.selectedFormula)) {
            return;
        }
        this.$scope.$apply(function () {
            _this.selectedFormula.code = change.code;
            _this.onFormulaChange();
        });
    };
    ReportFormulasCtrl.prototype.selectFormula = function (formula) {
        var _this = this;
        if (_.isDefined(this.selectedFormula)
            && this.selectedFormula.id === formula.id) {
            return;
        }
        if (_.isUndefined(this.selectedFormula)
            || !this.selectedFormula.isChanged) {
            this.setNewSelected(formula);
        }
        else {
            this.saveFormula().then(function () {
                _this.setNewSelected(formula);
            });
        }
    };
    ReportFormulasCtrl.prototype.insertFormula = function () {
        var _this = this;
        this.$modal.open({
            templateUrl: 'ng1/dist/src/UserDocuments/ReportFormulas/ReportFormulaSelectModal/ReportFormulaSelectModal.html',
            controller: 'reportFormulaSelectModalCtrl',
            backdrop: 'static',
            windowClass: 'app-modal-window',
            resolve: {
                resultTypes: function () { return _this.resultTypes; },
                currentFormulaName: function () { return _this.selectedFormula.name; }
            }
        }).result.then(function (selectedFormula) {
            var parametersString = _.map(selectedFormula.parameters, function (p, i) { return "param".concat(i + 1); }).join(', ');
            _this.codeEditor.insert(selectedFormula.name + "(".concat(parametersString, ")"));
            _this.codeEditor.focus();
            _this.onFormulaChange();
        }, function () { });
    };
    ReportFormulasCtrl.prototype.openHelp = function () {
        this.$modal.open({
            templateUrl: 'ng1/dist/src/UserDocuments/Administration/ParameterEditModal/HelpModal.html',
            controller: 'parameterEditHelpModalCtrl',
            windowClass: 'app-modal-window-help',
            backdrop: 'static'
        }).result.then(function () { }, function () { });
    };
    ;
    ReportFormulasCtrl.prototype.insertParameter = function () {
        this.selectedFormula.parameters.push({
            name: 'parameter_' + (this.selectedFormula.parameters.length + 1),
            type: 'double',
            selectedType: _.find(this.resultTypes, function (type) { return type.ident === 'double'; })
        });
        this.onFormulaChange();
    };
    ReportFormulasCtrl.prototype.copyParameter = function (parameter) {
        this.selectedFormula.parameters.push({
            name: parameter.name,
            type: parameter.type,
            selectedType: _.find(this.resultTypes, function (type) { return type.ident === parameter.type; })
        });
        this.onFormulaChange();
    };
    ReportFormulasCtrl.prototype.deleteParameter = function (parameter) {
        this.selectedFormula.parameters.splice(_.findIndex(this.selectedFormula.parameters, function (p) { return p.name == parameter.name; }), 1);
        this.onFormulaChange();
    };
    ReportFormulasCtrl.prototype.createFormula = function () {
        var _this = this;
        this.saveFormula().then(function () {
            var uniqueName = _this.getUniqueName(_.map(_this.formulas, function (dto) { return dto.name; }), _this.uniqueNamePattern);
            _this.reportFormulasProvider.createDefaultFormula(uniqueName).then(function (formula) {
                _this.formulas.push(formula);
                _this.setNewSelected(formula);
            }, function (error) {
                _this.notificationService.errorMessage(_this.language.getElementValue('failedCreateReportFormulaMsg'), error);
            });
        });
    };
    ReportFormulasCtrl.prototype.saveFormula = function (isHideNoModalBtn) {
        var _this = this;
        if (isHideNoModalBtn === void 0) { isHideNoModalBtn = false; }
        if (!this.selectedFormula) {
            return Promise.resolve();
        }
        if (!this.selectedFormula.isChanged) {
            return Promise.resolve();
        }
        if (this.isParametersIncorrect()) {
            this.notificationService.warnMessage(this.language.getElementValue('parametersNamesMustBeUniqueMsg'));
            return Promise.reject();
        }
        if (this.selectedFormula.name.contains(' ')) {
            this.notificationService.warnMessage(this.language.getElementValue('formulaNameMustNotContainSpacesMsg'));
            return Promise.reject();
        }
        if (_.any(this.formulas, function (f) { return f.id !== _this.selectedFormula.id && f.name === _this.selectedFormula.name; })) {
            this.notificationService.warnMessage(this.language.getElementValue('formulaNameMustBeUniqueMsg'));
            return Promise.reject();
        }
        var deferred = this.$q.defer();
        this.reportFormulasProvider.getFormulaUsage(this.selectedFormula.id)
            .then(function (result) {
            if (result.formulas.length === 0 && result.templates.length === 0) {
                _this.save()
                    .then(function () {
                    deferred.resolve();
                })
                    .catch(function () {
                    deferred.reject();
                });
                return;
            }
            return _this.$modal.open({
                templateUrl: 'ng1/dist/src/UserDocuments/ReportFormulas/ReportFormulaActionModal/ReportFormulaActionModal.html',
                controller: 'reportFormulaActionModalCtrl as ctrl',
                backdrop: 'static',
                resolve: {
                    header: function () { return _this.language.getElementValue('reportFormulaSaveHdr'); },
                    confirmHeader: function () { return _this.language.getElementValue('reportFormulaCreateConfirmHdr'); },
                    warnMessage: function () { return _this.language.getElementValue('reportFormulaSaveWarningMsg'); },
                    formula: function () { return _this.selectedFormula.name; },
                    formulas: function () { return result.formulas; },
                    templates: function () { return result.templates; },
                    isHideNoBtn: function () { return isHideNoModalBtn; }
                }
            }).result.then(function (result) {
                if (!result) {
                    deferred.resolve();
                    return;
                }
                _this.save()
                    .then(function () {
                    deferred.resolve();
                })
                    .catch(function () {
                    deferred.reject();
                });
            })
                .catch(function () {
                deferred.reject();
            });
        });
        return deferred.promise;
    };
    ReportFormulasCtrl.prototype.save = function () {
        var _this = this;
        return this.reportFormulasProvider
            .update(this.selectedFormula)
            .then(function (errorsInfo) {
            _this.selectedFormula.isChanged = false;
            var updatedFormulaIdx = _.findIndex(_this.formulas, function (f) { return f.id === _this.selectedFormula.id; });
            _this.formulas[updatedFormulaIdx] = _this.selectedFormula;
            _this.notificationService.showMessage(_this.language.getElementValue('changesSuccessSaveMsg'));
            _this.setEditorErrors(errorsInfo);
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    ReportFormulasCtrl.prototype.onCopyFormula = function () {
        var _this = this;
        if (_.isUndefined(this.selectedFormula)) {
            return;
        }
        if (this.selectedFormula.isChanged) {
            this.saveFormula().then(function () {
                _this.copyFormula();
            });
        }
        else {
            this.copyFormula();
        }
    };
    ReportFormulasCtrl.prototype.deleteFormula = function () {
        var _this = this;
        if (_.isUndefined(this.selectedFormula)) {
            return;
        }
        this.reportFormulasProvider.getFormulaUsage(this.selectedFormula.id)
            .then(function (result) {
            _this.$modal.open({
                templateUrl: 'ng1/dist/src/UserDocuments/ReportFormulas/ReportFormulaActionModal/ReportFormulaActionModal.html',
                controller: 'reportFormulaActionModalCtrl as ctrl',
                backdrop: 'static',
                resolve: {
                    header: function () { return _this.language.getElementValue('reportDeleteFormulaHdr'); },
                    confirmHeader: function () { return _this.language.getElementValue('reportFormulaDeleteConfirmHdr'); },
                    warnMessage: function () { return _this.language.getElementValue('reportFormulaDeleteWarningMsg'); },
                    formula: function () { return _this.selectedFormula.name; },
                    formulas: function () { return result.formulas; },
                    templates: function () { return result.templates; },
                    isHideNoBtn: function () { return true; }
                }
            }).result.then(function () {
                _this.reportFormulasProvider
                    .delete([_this.selectedFormula.id])
                    .then(function () {
                    var deletedItemIdx = _.findIndex(_this.formulas, function (dto) {
                        return dto.id === _this.selectedFormula.id;
                    });
                    if (deletedItemIdx > -1) {
                        _this.formulas.splice(deletedItemIdx, 1);
                        _this.setNewSelected(undefined);
                        var newSelectedFormulaIdx = deletedItemIdx > 0
                            ? deletedItemIdx - 1
                            : 0;
                        if (_this.formulas.length > 0) {
                            _this.selectFormula(_this.formulas[newSelectedFormulaIdx]);
                        }
                    }
                    _this.notificationService.showMessage(_this.language.getElementValue('reportFormulaSuccessDeleteMsg'));
                }, function (data) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('failedDeleteReportFormulaMsg'), data);
                });
            }, function () { });
        });
    };
    ReportFormulasCtrl.prototype.isFormulaValid = function () {
        var _this = this;
        if (this.isParametersIncorrect()) {
            this.notificationService.warnMessage(this.language.getElementValue('parametersNamesMustBeUniqueMsg'));
            return;
        }
        this.selectedFormula.code = this.codeEditor.getValue();
        this.reportFormulasProvider.isFormulaValid(this.selectedFormula)
            .then(function (errorsInfo) {
            return _this.setEditorErrors(errorsInfo);
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    ReportFormulasCtrl.prototype.onReturnTypeRefresh = function (type) {
        var ident = type.trim();
        if (_.isEmpty(ident)) {
            return;
        }
        var returnType = _.find(this.resultTypes, function (t) { return t.ident === ident; });
        this.selectedReturnType = returnType !== null && returnType !== void 0 ? returnType : new UiSelectItem(ident, ident);
        this.onReturnTypeChange();
    };
    ReportFormulasCtrl.prototype.onReturnTypeChange = function () {
        this.selectedFormula.returnType = this.selectedReturnType.ident;
        this.onFormulaChange();
    };
    ReportFormulasCtrl.prototype.onParameterReturnTypeRefresh = function (parameter, type) {
        type = type.trim();
        if (_.isEmpty(type)) {
            return;
        }
        var returnType = _.find(this.resultTypes, function (t) { return t.ident === type; });
        parameter.type = returnType
            ? returnType.ident
            : type;
        parameter.selectedType = new UiSelectItem(parameter.type, parameter.type);
        this.onFormulaChange();
    };
    ReportFormulasCtrl.prototype.onParameterReturnTypeChange = function (parameter, selectedType) {
        if (_.isDefined(selectedType)) {
            parameter.type = selectedType.ident;
            parameter.selectedType = _.find(this.resultTypes, function (type) { return type.ident === selectedType.ident; });
        }
        this.onFormulaChange();
    };
    ReportFormulasCtrl.prototype.exportFormulas = function () {
        this.exportService.export('/ReportFormulas/Export');
    };
    ;
    ReportFormulasCtrl.prototype.isParametersIncorrect = function () {
        var _this = this;
        return _.any(this.selectedFormula.parameters, function (item, index) { return _.contains(item.name, ' ') || /^\d/.test(item.name) || _.some(_this.selectedFormula.parameters, function (elem, idx) { return idx !== index && elem.name === item.name; }); });
    };
    ReportFormulasCtrl.prototype.setEditorErrors = function (errorsInfo) {
        var _this = this;
        if (_.isEmpty(errorsInfo.errors)) {
            this.codeEditor.getSession().clearAnnotations();
            this.notificationService.showMessage(this.language.getElementValue('formulaErrorsNotFoundMsg'));
        }
        else {
            this.notificationService.warnMessage(this.language.getElementValue('formulaContainsErrorsMsg'), errorsInfo);
            this.codeEditor.getSession().clearAnnotations();
            var errorGroups = _.groupBy(errorsInfo.errors, function (error) { return error.line; });
            var annotationArray = Object.entries(errorGroups).map(function (_a) {
                var _ = _a[0], errors = _a[1];
                return errors.map(function (error) {
                    return ({
                        row: error.line,
                        text: _this.language.getElementValue('errorsHdr') + ':\n' +
                            errors
                                .map(function (errorLine) { return "".concat(errorLine.errorNumber, ": ").concat(errorLine.errorText); })
                                .reduce(function (memo, text) { return memo + '\n' + text; }, '')
                                .trim()
                                .slice(0, 500) + ' ...',
                        type: 'error',
                    });
                });
            });
            this.codeEditor.getSession().setAnnotations(_.flatten(annotationArray));
        }
    };
    ReportFormulasCtrl.prototype.copyFormula = function () {
        var _this = this;
        var clone = ReportFormula.clone(this.selectedFormula);
        clone.id = 0;
        var uniqueName = this.getUniqueName(_.map(this.formulas, function (dto) { return dto.name; }), String.Format(this.language.getElementValue('copyHdr'), clone.name));
        clone.name = uniqueName;
        this.reportFormulasProvider.create(clone).then(function (data) {
            _this.formulas.push(data);
            _this.setNewSelected(data);
        }, function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedCreateReportFormulaMsg'), data);
        });
    };
    ReportFormulasCtrl.prototype.getUniqueName = function (names, name) {
        var i = 1;
        while (_.indexOf(names, name + i) !== -1) {
            i++;
        }
        return name + i;
    };
    ;
    ReportFormulasCtrl.prototype.setNewSelected = function (formula) {
        var _this = this;
        if (_.isDefined(formula)) {
            this.selectedFormula = new ReportFormula(formula);
            var type = _.find(this.resultTypes, function (t) { return t.ident === formula.returnType; });
            this.selectedReturnType = type !== null && type !== void 0 ? type : new UiSelectItem(formula.returnType, formula.returnType);
            _.forEach(this.selectedFormula.parameters, function (p) {
                var type = _.find(_this.resultTypes, function (type) { return type.ident === p.type; });
                p.selectedType = type !== null && type !== void 0 ? type : new UiSelectItem(p.type, p.type);
            });
        }
        else {
            this.selectedFormula = undefined;
        }
    };
    ReportFormulasCtrl.prototype.onFormulaChange = function () {
        this.selectedFormula.isChanged = true;
    };
    ReportFormulasCtrl.$inject = [
        '$window',
        '$rootScope',
        '$scope',
        '$modal',
        '$location',
        '$upload',
        '$q',
        'clientSettings',
        'exportService',
        'reportFormulasProvider',
        'notificationService',
        'language',
        'reportCompletionsProvider'
    ];
    return ReportFormulasCtrl;
}());
angular.module('kamhpp').controller('reportFormulasCtrl', ReportFormulasCtrl);
