var ReportTemplateImportInfo = (function () {
    function ReportTemplateImportInfo(reportTemplateImportInfo) {
        this.uniqueGuid = reportTemplateImportInfo.uniqueGuid;
        this.name = reportTemplateImportInfo.name;
        this.chapter = reportTemplateImportInfo.chapter;
        this.status = reportTemplateImportInfo.status;
        this.isSelected = true;
    }
    return ReportTemplateImportInfo;
}());
var InformationImportingReportTemplatesModalCtrl = (function () {
    function InformationImportingReportTemplatesModalCtrl($modalInstance, language, reportTemplateProvider, licenseStorage, notificationService, reportTemplates, totalTemplatesCount) {
        this.$modalInstance = $modalInstance;
        this.language = language;
        this.reportTemplateProvider = reportTemplateProvider;
        this.licenseStorage = licenseStorage;
        this.notificationService = notificationService;
        this.totalTemplatesCount = totalTemplatesCount;
        this.isAllTemplatesSelected = true;
        this.reportChapters = [];
        this.searchTemplate = { name: '' };
        this.license = this.licenseStorage.load();
        var reportGroupByChapter = _.groupBy(_.map(reportTemplates, function (template) { return new ReportTemplateImportInfo(template); }), function (item) {
            return item.chapter;
        });
        for (var key in reportGroupByChapter) {
            this.reportChapters.push(new ReportChapterInfo(key, reportGroupByChapter[key]));
        }
    }
    InformationImportingReportTemplatesModalCtrl.prototype.isChapterVisible = function (chapter) {
        var _this = this;
        return _.any(chapter.templates, function (template) {
            return template.name.toLowerCase().contains(_this.searchTemplate.name.toLowerCase());
        });
    };
    InformationImportingReportTemplatesModalCtrl.prototype.changeAllTemplatesSelection = function () {
        var _this = this;
        if (this.searchTemplate.name === '') {
            _.forEach(this.reportChapters, function (chapter) {
                chapter.isSelected = !_this.isAllTemplatesSelected;
                _.forEach(chapter.templates, function (template) {
                    template.isSelected = !_this.isAllTemplatesSelected;
                });
            });
        }
        else {
            _.forEach(this.reportChapters, function (chapter) {
                _.forEach(chapter.templates, function (template) {
                    if (template.name.toLowerCase().contains(_this.searchTemplate.name.toLowerCase())) {
                        template.isSelected = !_this.isAllTemplatesSelected;
                    }
                });
                chapter.isSelected = !_this.isAllTemplatesSelected;
            });
        }
    };
    InformationImportingReportTemplatesModalCtrl.prototype.changeChapterSelection = function (chapter) {
        var _this = this;
        chapter.isSelected = !chapter.isSelected;
        if (this.searchTemplate.name === '') {
            _.forEach(chapter.templates, function (template) {
                template.isSelected = chapter.isSelected;
            });
            this.isAllTemplatesSelected = _.all(this.reportChapters, function (chapter) { return _.all(chapter.templates, function (template) { return template.isSelected; }); });
        }
        else {
            _.forEach(chapter.templates, function (template) {
                if (template.name.toLowerCase().contains(_this.searchTemplate.name.toLowerCase())) {
                    template.isSelected = chapter.isSelected;
                }
            });
            var filteredChapters = _.filter(this.reportChapters, function (chapter) { return !_.isEmpty(_.filter(chapter.templates, function (template) { return template.name.toLowerCase().contains(_this.searchTemplate.name.toLowerCase()); })); });
            this.isAllTemplatesSelected = _.all(filteredChapters, function (chapter) { return chapter.isSelected; });
        }
    };
    InformationImportingReportTemplatesModalCtrl.prototype.changeTemplateSelection = function (template) {
        template.isSelected = !template.isSelected;
        this.checkAllSelected();
    };
    InformationImportingReportTemplatesModalCtrl.prototype.checkAllSelected = function () {
        var _this = this;
        _.forEach(this.reportChapters, function (chapter) {
            var filteredTemplates = _this.searchTemplate.name === ''
                ? chapter.templates
                : _.filter(chapter.templates, function (template) { return template.name.toLowerCase().contains(_this.searchTemplate.name.toLowerCase()); });
            chapter.isSelected = _.all(filteredTemplates, function (template) { return template.isSelected; });
        });
        this.isAllTemplatesSelected = _.all(this.reportChapters, function (chapter) { return chapter.isSelected; });
    };
    InformationImportingReportTemplatesModalCtrl.prototype.ok = function () {
        var selectedReportTemplates = _.flatten(_.map(this.reportChapters, function (chapter) { return _.filter(chapter.templates, function (template) { return template.isSelected; }); }));
        this.$modalInstance.close(selectedReportTemplates);
    };
    InformationImportingReportTemplatesModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    InformationImportingReportTemplatesModalCtrl.$inject = [
        '$modalInstance',
        'language',
        'reportTemplateProvider',
        'licenseStorage',
        'notificationService',
        'reportTemplates',
        'totalTemplatesCount'
    ];
    return InformationImportingReportTemplatesModalCtrl;
}());
app.controller('informationImportingReportTemplatesModalCtrl', InformationImportingReportTemplatesModalCtrl);
