var ExportService = (function () {
    function ExportService(http, window, clientSettings, browserInfoProvider) {
        this.http = http;
        this.window = window;
        this.clientSettings = clientSettings;
        this.browserInfoProvider = browserInfoProvider;
    }
    ExportService.prototype.export = function (exportUrl, params) {
        var _this = this;
        if (params === void 0) { params = undefined; }
        var url = this.clientSettings.getServerInstance() + exportUrl;
        var options = { responseType: 'blob' };
        var request = _.isDefined(params)
            ? this.http.post(url, params, options)
            : this.http.get(url, options);
        if (!_.isDefined(params) && (this.browserInfoProvider.isQTWebKit() || this.browserInfoProvider.isQTWebEngine())) {
            this.exportFileWinccOa(url);
            return;
        }
        request.then(function (response) {
            if (_this.browserInfoProvider.isQTWebKit() || _this.browserInfoProvider.isQTWebEngine()) {
                _this.exportFileBase64(response.data);
            }
            else {
                var contentDisposition = response.headers('content-disposition');
                var split = contentDisposition.split('filename*=UTF-8\'\'');
                if (split.length === 1) {
                    _this.exportFile(response.data);
                    return;
                }
                var decodedText = decodeURIComponent(split[1]);
                _this.exportFile(response.data, decodedText);
            }
        });
    };
    ExportService.prototype.exportFile = function (blob, fileName) {
        if (fileName === void 0) { fileName = ''; }
        var url = this.window.URL.createObjectURL(blob);
        var link = document.createElement('a');
        link.href = url;
        link.download = fileName;
        this.click(link);
        this.window.URL.revokeObjectURL(url);
        link.remove();
    };
    ExportService.prototype.exportFileBase64 = function (data) {
        var _this = this;
        var reader = new FileReader();
        reader.readAsDataURL(data);
        reader.onloadend = function () {
            var link = document.createElement('a');
            link.href = reader.result;
            _this.click(link);
        };
    };
    ExportService.prototype.exportFileWinccOa = function (url) {
        var link = document.createElement('a');
        link.href = url.indexOf("?") != -1
            ? url + "&scada-export"
            : url + "?scada-export";
        this.click(link);
    };
    ExportService.prototype.click = function (link) {
        if (this.browserInfoProvider.isFirefox()) {
            link.dispatchEvent(new MouseEvent('click'));
        }
        else {
            link.click();
        }
    };
    ExportService.$inject = [
        '$http',
        '$window',
        'clientSettings',
        'browserInfoProvider'
    ];
    return ExportService;
}());
angular.module('kamhpp').service('exportService', ExportService);
