var LicenseStorage = (function () {
    function LicenseStorage(licenseProvider) {
        var _this = this;
        this.licenseProvider = licenseProvider;
        this.licenseProvider.getLicense().then(function (license) {
            _this.license = license;
            localStorage.setItem(LicenseStorage.LicenseStorageKey, JSON.stringify(license));
        });
    }
    LicenseStorage.prototype.save = function (license) {
        this.license = license;
        localStorage.setItem(LicenseStorage.LicenseStorageKey, JSON.stringify(license));
    };
    LicenseStorage.prototype.load = function () {
        if (this.license) {
            return this.license;
        }
        var licenseString = localStorage.getItem(LicenseStorage.LicenseStorageKey);
        if (licenseString) {
            this.license = JSON.parse(licenseString);
            return this.license;
        }
    };
    LicenseStorage.prototype.hasModule = function (module) {
        var license = this.load();
        if (_.isUndefined(license)) {
            return false;
        }
        switch (module) {
            case 62376423:
                return _.isDefined(license.modules.reports);
            case 6239971:
                return _.isDefined(license.modules.switchoverForms);
            case 6526756:
                return _.isDefined(license.modules.operationTime);
            case 87623764:
                return _.isDefined(license.modules.cim);
            default:
                break;
        }
    };
    LicenseStorage.$inject = [
        'licenseProvider'
    ];
    LicenseStorage.LicenseStorageKey = 'license';
    return LicenseStorage;
}());
angular.module('kamhpp').service('licenseStorage', LicenseStorage);
