var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var ReportTree = (function (_super) {
    __extends(ReportTree, _super);
    function ReportTree(language, dateFilter) {
        var _this = _super.call(this) || this;
        _this.language = language;
        _this.dateFilter = dateFilter;
        _this.formatFullNameMonth = 'MMMM';
        _this.formatFullNameYear = 'YYYY';
        _this.formatDayHourMin = 'DD - HH:mm';
        _this.formatDayHourMinSec = 'DD - HH:mm:ss';
        _this.formatDayMonthYearHourMinSec = 'DD.MM.YYYY - HH:mm:ss';
        _this.formatMonthNumber = 'M';
        _this.formatMonthZeroNumber = 'MM';
        _this.settings = new SmsTreeSettings([new SmsTreeColumn(_this.language.getElementValue('reportListHdr'), 'Name')], null, $.jstree.defaults.core.themes, new SmsTypes('glyphicon glyphicon-none', 'fa fa-folder', 'fa fa-file-o', 'fa fa-exclamation-triangle', 'fa fa-exclamation-triangle'), ['types', 'wholerow', 'grid'], 0, null, true, null);
        return _this;
    }
    ReportTree.prototype.getNodeInfo = function (nodeId) {
        var treeData = this.element.jstree().settings.core.data;
        var node = _.find(treeData, function (i) {
            return _.isDefined(i.info) && i.id === nodeId;
        });
        return {
            id: node.info.id,
            templateId: node.info.templateId,
            startDate: node.info.startDate,
            endDate: node.info.endDate,
            calculationResult: node.info.calculationResult,
            predefinedValuesInfo: node.info.predefinedValuesInfo,
        };
    };
    ReportTree.prototype.getNodeId = function (reportId) {
        return 'report_' + reportId;
    };
    ReportTree.prototype.selectLastNode = function () {
        var newSelectedNodeId;
        var treeData = this.element.jstree().settings.core.data;
        for (var i = treeData.length - 1; i >= 0; i--) {
            if (treeData[i].type === 'file' || treeData[i].type === 'errorfile') {
                newSelectedNodeId = treeData[i].id;
                break;
            }
        }
        if (!_.isUndefined(newSelectedNodeId)) {
            this.element.jstree().deselect_all();
            this.element.jstree().select_node(newSelectedNodeId);
        }
    };
    ReportTree.prototype.deselectAll = function () {
        this.element.jstree().deselect_all();
    };
    ReportTree.prototype.getLastNodeId = function () {
        var node = this.getLastNode();
        return node ? node.id : null;
    };
    ReportTree.prototype.getLastNode = function () {
        var lastNode;
        var treeData = this.element.jstree().settings.core.data;
        for (var i = treeData.length - 1; i >= 0; i--) {
            if (treeData[i].type === 'file' || treeData[i].type === 'errorfile') {
                lastNode = treeData[i];
                break;
            }
        }
        return lastNode;
    };
    ReportTree.prototype.selectNode = function (startDate, endDate, predefinedParametersHashCode) {
        var nodeId = this.getNodeIdByKey(startDate, endDate, predefinedParametersHashCode);
        this.selectNodeById(nodeId);
    };
    ReportTree.prototype.selectNodeById = function (nodeId) {
        var treeData = this.element.jstree().settings.core.data;
        var newSelectedNodeId = _.find(treeData, function (i) {
            return i.id === nodeId;
        });
        if (newSelectedNodeId) {
            this.element.jstree().deselect_all();
            this.element.jstree().select_node(newSelectedNodeId);
        }
    };
    ReportTree.prototype.updateTreeNode = function (reportId, calculationResult, updatedTreeNodes) {
        var treeData = this.element.jstree().settings.core.data;
        var nodeId = this.getNodeId(reportId);
        var node = _.find(treeData, function (node) { return node.id === nodeId; });
        var newNodeType = calculationResult === 1 ? 'errorfile' : 'file';
        if (node.type !== newNodeType) {
            node.type = newNodeType;
            node.info.calculationResult = calculationResult;
            this.element.jstree().set_type(node, newNodeType);
            updatedTreeNodes.push(node);
        }
    };
    ReportTree.prototype.updateTreeNodeAfterRecalc = function (result, updatedTreeNodes) {
        if (result.success) {
            this.updateTreeNode(result.id, result.value.CalculationResult, updatedTreeNodes);
            if (result.timestamp.getTime() === result.endTimestamp.getTime()) {
                return new NotificationMessage(String.Format(this.language.getElementValue('reportOnTimestampSuccessCreateMsg'), result.timestamp.format('dd.mm.yyyy HH:MM')));
            }
            else {
                return new NotificationMessage(String.Format(this.language.getElementValue('reportOnIntervalSuccessCreateMsg'), result.timestamp.format('dd.mm.yyyy HH:MM'), result.endTimestamp.format('dd.mm.yyyy HH:MM')));
            }
        }
        else {
            return new NotificationMessage(this.language.getElementValue('failedLoadDataServerMsg'));
        }
    };
    ReportTree.prototype.refreshCalculationStateOfParentNodes = function (treeNodes) {
        var _this = this;
        var treeData = this.element.jstree().settings.core.data;
        treeNodes = _.uniq(treeNodes, function (node) { return node.parent; });
        _.forEach(treeNodes, function (node) {
            _this.updateParentsNodesType(treeData, node);
        });
    };
    ReportTree.prototype.addReportToTree = function (report, template) {
        var _this = this;
        var rootId = '#';
        var treeData = this.element.jstree().settings.core.data;
        var ts = Date.fromCString(report.StartTime);
        var endTs = Date.fromCString(report.EndTime);
        var extractText = function (str) {
            return str.substring(str.lastIndexOf('_') + 1);
        };
        var yearNodeId = template.uniqueGuid + '_' + ts.getFullYear();
        var yearNode = _.find(treeData, function (arg) {
            return arg.id === yearNodeId;
        });
        if (_.isUndefined(yearNode)) {
            var yearComparator = function (str, comparisonValue1) {
                return parseInt(extractText(str)) >= comparisonValue1;
            };
            this.addNodeToTree(yearNodeId, rootId, report.CalculationResult === 0 ? 'folder' : 'errorfolder', 'year', ts.getFullYear(), this.getPosition(rootId, yearComparator, ts.getFullYear()));
        }
        else if (report.CalculationResult === 1) {
            yearNode.type = 'errorfolder';
        }
        var creationMoment = moment(ts);
        creationMoment.lang(this.language.language);
        var monthNodeId = yearNodeId + '_' + creationMoment.format(this.formatMonthNumber);
        var monthNode = _.find(treeData, function (arg) {
            return arg.id === monthNodeId;
        });
        if (_.isUndefined(monthNode)) {
            var monthParentId = yearNodeId;
            var monthComparator = function (str, comparisonValue1) {
                return parseInt(extractText(str)) >= comparisonValue1;
            };
            this.addNodeToTree(monthNodeId, monthParentId, report.CalculationResult === 0 ? 'folder' : 'errorfolder', 'month', this.getReportMonthAsTreeNodeName(ts), this.getPosition(monthParentId, monthComparator, ts.getMonth() + 1));
        }
        else if (report.CalculationResult === 1) {
            monthNode.type = 'errorfolder';
        }
        var reportCode = this.getNodeId(report.Id);
        var parentReportId = monthNodeId;
        var dateComparator = function (str, startDate, endDate) {
            var nodeInfo = _this.getNodeInfo(str);
            return nodeInfo.startDate >= startDate && nodeInfo.endDate >= endDate;
        };
        this.addNodeToTree(reportCode, parentReportId, report.CalculationResult === 0 ? 'file' : 'errorfile', 'report', this.getReportPointName({ start: ts, stop: endTs }), this.getPosition(parentReportId, dateComparator, ts, endTs), report.Id, {
            id: report.Id,
            templateId: report.TemplateId,
            startDate: report.StartTime,
            endDate: report.EndTime,
            calculationResult: report.CalculationResult,
            predefinedValuesInfo: report.PredefinedValues,
        });
        this.element.jstree('refresh');
        return reportCode;
    };
    ReportTree.prototype.deleteReportsFromTree = function (deletedReportsInfo) {
        var _this = this;
        var treeData = this.element.jstree().settings.core.data;
        var deleteNodes = _.filter(treeData, function (node) { return _.isDefined(node.info) && _.any(deletedReportsInfo, function (r) { return r.id === node.info.id; }); });
        _.forEach(deleteNodes, function (node) {
            treeData.splice(treeData.indexOf(node), 1);
            _this.updateParentsNodesType(treeData, node);
        });
        if (_.all(treeData, function (node) { return node.type === 'folder' || node.type === 'errorfolder'; })) {
            this.element.jstree().settings.core.data = [];
        }
        else {
            var folderNodes = _.filter(treeData, function (node) { return node.type === 'folder' || node.type === 'errorfolder'; });
            var monthNodesToDelete_1 = _.filter(folderNodes, function (folderNode) { return !_.any(treeData, function (node) { return node.parent === folderNode.id; }); });
            var yearsNodesToDelete = _.filter(folderNodes, function (folderNode) {
                return !_.any(_.filter(treeData, function (node) { return !_.any(monthNodesToDelete_1, function (monthNode) { return node.id === monthNode.id; }); }), function (node) { return node.parent === folderNode.id; });
            });
            var folderNodesToDelete_1 = __spreadArray(__spreadArray([], monthNodesToDelete_1, true), yearsNodesToDelete, true);
            this.element.jstree().settings.core.data = _.filter(treeData, function (node) { return !_.any(folderNodesToDelete_1, function (folderNode) { return node.id === folderNode.id; }); });
        }
        this.element.jstree('refresh');
    };
    ReportTree.prototype.drawTree = function (reportTreeNodes) {
        var _this = this;
        var treeNodes = [];
        _.forEach(reportTreeNodes, function (n) {
            treeNodes.push({
                id: n.id,
                parent: n.parentId,
                type: _this.containsErrorReport(reportTreeNodes, n) ? 'errorfolder' : 'folder',
                text: n.type === 1
                    ? new Date(n.number, 0, 1).getFullYear()
                    : _this.getReportMonthAsTreeNodeName(new Date(1, n.number - 1, 1)),
            });
            _.forEach(n.points, function (p) {
                treeNodes.push({
                    id: p.id,
                    parent: n.id,
                    info: p.info,
                    type: p.info.calculationResult === 1 ? 'errorfile' : 'file',
                    text: _this.getReportPointName(new TimeInterval(p.info.startDate, p.info.endDate)),
                    a_attr: {
                        title: _this.getPredefinedValuesPointText(p.info.predefinedValuesInfo),
                    },
                });
            });
        });
        this.element.jstree().settings.core.data = treeNodes;
        this.element.jstree('refresh');
    };
    ReportTree.prototype.getReportsInfo = function () {
        var _this = this;
        var treeData = this.element.jstree().settings.core.data;
        var reports = _.filter(treeData, function (item) {
            return item.type === 'report' || item.type === 'file' || item.type === 'errorfile';
        });
        return _.map(reports, function (item) {
            var nodeInfo = _this.getNodeInfo(item.id);
            return new ReportOperationInfo.ReportInfo(nodeInfo.id, nodeInfo.templateId, nodeInfo.startDate, nodeInfo.endDate, nodeInfo.predefinedValuesInfo);
        });
    };
    ReportTree.prototype.getSelectedReportsInfo = function () {
        var _this = this;
        var treeData = this.element.jstree().settings.core.data;
        var selectedReportNodes = _.filter(treeData, function (node) {
            return ((node.type === 'report' || node.type === 'file' || node.type === 'errorfile') &&
                _.any(_this.selectedElements, function (selectedElement) { return selectedElement === node.id; }));
        });
        return _.map(selectedReportNodes, function (node) {
            return {
                id: node.info.id,
                templateId: node.info.templateId,
                startDate: node.info.startDate,
                endDate: node.info.endDate,
                calculationResult: node.info.calculationResult,
                predefinedValuesInfo: node.info.predefinedValuesInfo,
            };
        });
    };
    ReportTree.prototype.hasNodes = function () {
        return this.element.jstree().settings.core.data.length !== 0;
    };
    ReportTree.prototype.getNodeIdByKey = function (startDate, endDate, predefinedParametersHashCode) {
        var treeData = this.element.jstree().settings.core.data;
        var node = _.find(treeData, function (i) {
            var _a;
            return (_.isDefined(i.info) &&
                i.info.startDate.toLongString() === startDate &&
                ((_a = i.info.endDate) === null || _a === void 0 ? void 0 : _a.toLongString()) === endDate &&
                i.info.predefinedValuesInfo.HashCode === predefinedParametersHashCode);
        });
        return _.isDefined(node) ? node.id : null;
    };
    ReportTree.prototype.getReportMonthAsTreeNodeName = function (arg) {
        var mnt = moment(arg);
        mnt.lang(this.language.language);
        return mnt.format(this.formatFullNameMonth);
    };
    ReportTree.prototype.getReportPointName = function (interval) {
        var start = Date.fromCString(interval.start);
        var stop = Date.fromCString(interval.stop);
        var mnt = moment(start);
        var result = mnt.second() !== 0
            ? mnt.format(this.formatDayHourMinSec).replace(' - 00:00:00', '')
            : mnt.format(this.formatDayHourMin).replace(' - 00:00', '');
        if (start.getTime() !== stop.getTime()) {
            var endmnt = moment(stop);
            endmnt.lang(this.language.language);
            var endTimeAsString = endmnt
                .format(this.formatDayMonthYearHourMinSec)
                .replace('.' + mnt.format(this.formatMonthZeroNumber) + '.' + start.getFullYear() + ' ', ' ')
                .replace('.' + start.getFullYear() + ' ', ' ')
                .replace(' - 00:00:00', '')
                .replace(/:00$/, '');
            result = result + ' ━ ' + endTimeAsString;
        }
        return result;
    };
    ReportTree.prototype.getPosition = function (parentId, comparator, comparisonValue1, comparisonValue2) {
        var treeData = this.element.jstree().settings.core.data;
        var position = _.findIndex(treeData, function (node) {
            return node.parent === parentId && comparator(node.id, comparisonValue1, comparisonValue2);
        });
        return position === -1 ? 9999999 : position;
    };
    ReportTree.prototype.addNodeToTree = function (id, parent, type1, type2, text, position, reportId, reportInfo) {
        var node = {
            id: id,
            reportId: reportId,
            parent: parent,
            type: type1,
            text: text,
            info: reportInfo,
            a_attr: {
                title: this.getPredefinedValuesPointText(reportInfo === null || reportInfo === void 0 ? void 0 : reportInfo.predefinedValuesInfo),
            },
        };
        this.element.jstree().settings.core.data.splice(position, 0, node);
        this.element.jstree().settings.core.data = _.sortBy(this.element.jstree().settings.core.data, function (item) { var _a; return (_a = item.info) === null || _a === void 0 ? void 0 : _a.startDate; });
    };
    ReportTree.prototype.containsErrorReport = function (tree, node) {
        var _this = this;
        if (node.type === 1) {
            var months = _.filter(tree, function (n) {
                return n.parentId === node.id;
            });
            return _.any(months, function (month) {
                return _this.containsErrorReport(tree, month);
            });
        }
        if (node.type === 2) {
            return _.any(node.points, function (point) {
                return point.info.calculationResult === 1;
            });
        }
        return false;
    };
    ReportTree.prototype.updateParentsNodesType = function (treeData, reportNode) {
        var monthReports = _.filter(treeData, function (node) {
            return node.parent === reportNode.parent;
        });
        var month = _.find(treeData, function (node) {
            return node.id === reportNode.parent;
        });
        var newMonthType = _.any(monthReports, function (node) {
            return node.type === 'errorfile';
        })
            ? 'errorfolder'
            : 'folder';
        if (month.type === newMonthType) {
            return;
        }
        month.type = newMonthType;
        this.element.jstree().set_type(month, month.type);
        var yearMonths = _.filter(treeData, function (node) {
            return node.parent === month.parent;
        });
        var year = _.find(treeData, function (node) {
            return node.id === month.parent;
        });
        year.type = _.any(yearMonths, function (node) {
            return node.type === 'errorfolder';
        })
            ? 'errorfolder'
            : 'folder';
        this.element.jstree().set_type(year, year.type);
    };
    ReportTree.prototype.getPredefinedValuesPointText = function (predefinedValues) {
        var _this = this;
        if (!predefinedValues) {
            return '';
        }
        return _.map(predefinedValues.ParameterValues, function (value, key) {
            if (value instanceof Date) {
                return key + ': ' + _this.convertDateToString(value);
            }
            if (_.isDefined(value.Variants)) {
                return key + ': ' + _.map(_.filter(value.Variants, function (v) { return v.IsSelected; }), function (val) { return val.Ident; }).join(',');
            }
            return key + ': ' + value;
        }).join('\n');
    };
    ReportTree.prototype.convertDateToString = function (date) {
        return this
            .dateFilter(date, Date.masks.fullDateTime)
            .replace(' 00:00:00', '')
            .replace(/:00$/, '');
        ;
    };
    return ReportTree;
}(SmsTree));
