var ClusterServerFailoverInterceptor = (function () {
    function ClusterServerFailoverInterceptor($q, notificationService, language, dateFilter) {
        var _this = this;
        this.$q = $q;
        this.notificationService = notificationService;
        this.language = language;
        this.dateFilter = dateFilter;
        this.response = function (response) {
            _this.handleServerFailover(response);
            return response;
        };
        this.responseError = function (response) {
            _this.handleServerFailover(response);
            return _this.$q.reject(response);
        };
    }
    ClusterServerFailoverInterceptor.Factory = function ($q, notificationService, language, dateFilter) {
        return new ClusterServerFailoverInterceptor($q, notificationService, language, dateFilter);
    };
    ClusterServerFailoverInterceptor.prototype.handleServerFailover = function (response) {
        var failoverDateHeaderValue = response.headers(dto.failoverDateHeaderName);
        if (failoverDateHeaderValue) {
            var date = new Date(+failoverDateHeaderValue);
            this.notificationService.warnMessage(this.language.getElementValue('clusterServerFailoverMsg'), String.Format(this.language.getElementValue('clusterServerFailoverMoreMsg'), this.dateFilter(date, Date.masks.fullDateTime)), undefined, undefined, true);
        }
    };
    ClusterServerFailoverInterceptor.$inject = ['$q', 'notificationService', 'language', 'dateFilter'];
    return ClusterServerFailoverInterceptor;
}());
