﻿BEGIN TRANSACTION;

CREATE TABLE "SFForms" (
    "Id" INTEGER PRIMARY KEY,
    "TemplateId" INTEGER NULL,
    "Name" TEXT NOT NULL,
    "SerialNumber" INTEGER NOT NULL CHECK ("SerialNumber" > 0),
    "HeaderHtml" TEXT NULL,
    "FooterHtml" TEXT NULL,
    "Status" INTEGER NOT NULL,
    "CreationDate" TEXT NOT NULL,
    "CloseDate" TEXT NULL,
    "StopDate" TEXT NULL,
    "StopReason" TEXT NULL,
    "StopUserFullName" TEXT NULL,
    UNIQUE("Name", "SerialNumber"),
    CONSTRAINT "FK_SFForms_SFTemplates_TemplateId" FOREIGN KEY ("TemplateId") REFERENCES "SFTemplates" ("Id") ON DELETE SET NULL
);

CREATE TABLE "SFFormOperations" (
    "Id" INTEGER PRIMARY KEY,
    "Description" TEXT NOT NULL,
    "Type" INTEGER NOT NULL,
    "OrderNumber" INTEGER NOT NULL,
    "Status" INTEGER NOT NULL,
    "ExecutionDate" TEXT NULL,
    "RemoteControlKeyPosition" INTEGER NOT NULL,
    "SwitchoverFormId" INTEGER NOT NULL,
    CONSTRAINT "FK_SFFormOperations_SFForms_SwitchoverFormId" FOREIGN KEY ("SwitchoverFormId") REFERENCES "SFForms" ("Id") ON DELETE CASCADE
);

CREATE TABLE "SFFormConditions" (
    "Id" INTEGER PRIMARY KEY,
    "Description" TEXT NOT NULL,
    "Type" INTEGER NOT NULL,
    "OrderNumber" INTEGER NOT NULL,
    "Status" INTEGER NOT NULL,
    "ExecutionDate" TEXT NULL,
    "RemoteControlKeyPosition" INTEGER NOT NULL,
    "SwitchoverFormId" INTEGER NOT NULL,
    CONSTRAINT "FK_SFFormConditions_SFForms_SwitchoverFormId" FOREIGN KEY ("SwitchoverFormId") REFERENCES "SFForms" ("Id") ON DELETE CASCADE
);

CREATE TABLE "SFFormOperationCommands" (
    "Id" INTEGER PRIMARY KEY,
    "Name" TEXT NULL,
    "Type" INTEGER NOT NULL,
    "Source" INTEGER NOT NULL,
    "OrderNumber" INTEGER NOT NULL,
    "TagAddress" TEXT NOT NULL,
    "Value" TEXT NOT NULL,
    "SwitchoverFormOperationId" INTEGER NOT NULL,
    CONSTRAINT "FK_SFFormOperationCommands_SFFormOperations_SwitchoverFormOperationId" FOREIGN KEY ("SwitchoverFormOperationId") REFERENCES "SFFormOperations" ("Id") ON DELETE CASCADE
);

CREATE TABLE "SFFormConditionCommands" (
    "Id" INTEGER PRIMARY KEY,
    "Name" TEXT NULL,
    "Type" INTEGER NOT NULL,
    "Source" INTEGER NOT NULL,
    "OrderNumber" INTEGER NOT NULL,
    "TagAddress" TEXT NOT NULL,
    "Value" TEXT NOT NULL,
    "SwitchoverFormConditionId" INTEGER NOT NULL,
    CONSTRAINT "FK_SFFormConditionCommands_SFFormConditions_SwitchoverFormConditionId" FOREIGN KEY ("SwitchoverFormConditionId") REFERENCES "SFFormConditions" ("Id") ON DELETE CASCADE
);

CREATE TABLE "SFSettings" (
    "Name" TEXT NOT NULL PRIMARY KEY,
    "Value" TEXT NULL
);

CREATE TABLE "SFTemplates" (
    "Id" INTEGER PRIMARY KEY,
    "Name" TEXT NOT NULL UNIQUE,
    "HeaderHtml" TEXT NULL,
    "FooterHtml" TEXT NULL,
    "IsTypical" INTEGER NOT NULL,
    "CreationDate" TEXT NULL,
    "CreatedUserName" TEXT NOT NULL,
    "ParentTemplateId" INTEGER NULL,
    CONSTRAINT "FK_SFTemplates_SFTemplates_ParentTemplateId" FOREIGN KEY ("ParentTemplateId") REFERENCES "SFTemplates" ("Id") ON DELETE SET NULL
);

CREATE TABLE "SFOperations" (
    "Id" INTEGER PRIMARY KEY,
    "Description" TEXT NOT NULL,
    "Type" INTEGER NOT NULL,
    "IsTypical" INTEGER NOT NULL
);

CREATE TABLE "SFConditions" (
    "Id" INTEGER PRIMARY KEY,
    "Description" TEXT NOT NULL,
    "Type" INTEGER NOT NULL,
    "IsTypical" INTEGER NOT NULL
);

CREATE TABLE "SFTemplateOperation" (
    "Id" INTEGER PRIMARY KEY,
    "SwitchoverFormTemplateId" INTEGER NOT NULL,
    "SwitchoverFormCommonOperationId" INTEGER NOT NULL,
    "OrderNumber" INTEGER NOT NULL,
    CONSTRAINT "FK_SFTemplateOperation_SFTemplates_SwitchoverFormTemplateId" FOREIGN KEY ("SwitchoverFormTemplateId") REFERENCES "SFTemplates" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_SFTemplateOperation_SFOperations_SwitchoverFormCommonOperationId" FOREIGN KEY ("SwitchoverFormCommonOperationId") REFERENCES "SFOperations" ("Id") ON DELETE RESTRICT
);

CREATE TABLE "SFTemplateCondition" (
    "Id" INTEGER PRIMARY KEY,
    "SwitchoverFormTemplateId" INTEGER NOT NULL,
    "SwitchoverFormCommonConditionId" INTEGER NOT NULL,
    "OrderNumber" INTEGER NOT NULL,
    CONSTRAINT "FK_SFTemplateCondition_SFTemplates_SwitchoverFormTemplateId" FOREIGN KEY ("SwitchoverFormTemplateId") REFERENCES "SFTemplates" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_SFTemplateCondition_SFConditions_SwitchoverFormCommonConditionId" FOREIGN KEY ("SwitchoverFormCommonConditionId") REFERENCES "SFConditions" ("Id") ON DELETE RESTRICT
);

CREATE TABLE "SFOperationCommands" (
    "Id" INTEGER PRIMARY KEY,
    "Name" TEXT NULL,
    "Type" INTEGER NOT NULL,
    "Source" INTEGER NOT NULL,
    "OrderNumber" INTEGER NOT NULL,
    "TagAddress" TEXT NOT NULL,
    "Value" TEXT NOT NULL,
    "SwitchoverFormCommonOperationId" INTEGER NOT NULL,
    CONSTRAINT "FK_SFOperationCommands_SFOperations_SwitchoverFormCommonOperationId" FOREIGN KEY ("SwitchoverFormCommonOperationId") REFERENCES "SFOperations" ("Id") ON DELETE CASCADE
);

CREATE TABLE "SFConditionCommands" (
    "Id" INTEGER PRIMARY KEY,
    "Name" TEXT NULL,
    "Type" INTEGER NOT NULL,
    "Source" INTEGER NOT NULL,
    "OrderNumber" INTEGER NOT NULL,
    "TagAddress" TEXT NOT NULL,
    "Value" TEXT NOT NULL,
    "SwitchoverFormCommonConditionId" INTEGER NOT NULL,
    CONSTRAINT "FK_SFConditionCommands_SFConditions_SwitchoverFormConditionId" FOREIGN KEY ("SwitchoverFormCommonConditionId") REFERENCES "SFConditions" ("Id") ON DELETE CASCADE
);

CREATE TABLE "SFFormAlarms" (
    "Id" INTEGER PRIMARY KEY,
    "Name" TEXT NOT NULL,
    "SwitchoverFormId" INTEGER NOT NULL,
    CONSTRAINT "FK_SFFormAlarms_SFForms_SwitchoverFormId" FOREIGN KEY ("SwitchoverFormId") REFERENCES "SFForms" ("Id") ON DELETE CASCADE
);

CREATE TABLE "SFFormAlarmCommands" (
    "Id" INTEGER PRIMARY KEY,
    "Name" TEXT NULL,
    "Source" INTEGER NOT NULL,
    "TagAddress" TEXT NOT NULL,
    "Value" TEXT NOT NULL,
    "SwitchoverFormAlarmId" INTEGER NOT NULL,
    CONSTRAINT "FK_SFFormAlarmCommands_SFFormAlarms_SwitchoverFormAlarmId" FOREIGN KEY ("SwitchoverFormAlarmId") REFERENCES "SFFormAlarms" ("Id") ON DELETE CASCADE
);

CREATE TABLE "SFFormTemplateAlarms" (
    "SwitchoverFormTemplateId" INTEGER NOT NULL,
    "SwitchoverFormCommonAlarmId" INTEGER NOT NULL,
    CONSTRAINT "PK_SFFormAlarms" PRIMARY KEY ("SwitchoverFormTemplateId", "SwitchoverFormCommonAlarmId"),
    CONSTRAINT "FK_SFFormTemplateAlarms_SFTemplates_SwitchoverFormTemplateId" FOREIGN KEY ("SwitchoverFormTemplateId") REFERENCES "SFTemplates" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_SFFormTemplateAlarms_SFFormCommonAlarms_SwitchoverFormCommonAlarmId" FOREIGN KEY ("SwitchoverFormCommonAlarmId") REFERENCES "SFFormCommonAlarms" ("Id") ON DELETE RESTRICT
);

CREATE TABLE "SFFormCommonAlarms" (
    "Id" INTEGER PRIMARY KEY,
    "Name" TEXT NOT NULL
);

CREATE TABLE "SFFormCommonAlarmCommands" (
    "Id" INTEGER PRIMARY KEY,
    "Name" TEXT NULL,
    "Source" INTEGER NOT NULL,
    "TagAddress" TEXT NOT NULL,
    "Value" TEXT NOT NULL,
    "SwitchoverFormCommonAlarmId" INTEGER NOT NULL,
    CONSTRAINT "FK_SFFormCommonAlarmCommands_SFFormCommonAlarms_SwitchoverFormCommonAlarmId" FOREIGN KEY ("SwitchoverFormCommonAlarmId") REFERENCES "SFFormCommonAlarms" ("Id") ON DELETE CASCADE
);


CREATE INDEX "IX_SFFormOperations_SwitchoverFormId" ON "SFFormOperations" ("SwitchoverFormId");

CREATE INDEX "IX_SFFormConditions_SwitchoverFormId" ON "SFFormConditions" ("SwitchoverFormId");

CREATE INDEX "IX_SFFormOperationCommands_SwitchoverFormOperationId" ON "SFFormOperationCommands" ("SwitchoverFormOperationId");

CREATE INDEX "IX_SFFormConditionCommands_SwitchoverFormConditionId" ON "SFFormConditionCommands" ("SwitchoverFormConditionId");

CREATE INDEX "IX_SFTemplates_ParentTemplateId" ON "SFTemplates" ("ParentTemplateId");

CREATE INDEX "IX_SFTemplateOperation_SwitchoverFormTemplateId" ON "SFTemplateOperation" ("SwitchoverFormTemplateId");

CREATE INDEX "IX_SFTemplateOperation_SwitchoverFormCommonOperationId" ON "SFTemplateOperation" ("SwitchoverFormCommonOperationId");

CREATE INDEX "IX_SFTemplateCondition_SwitchoverFormTemplateId" ON "SFTemplateCondition" ("SwitchoverFormTemplateId");

CREATE INDEX "IX_SFTemplateCondition_SwitchoverFormCommonConditionId" ON "SFTemplateCondition" ("SwitchoverFormCommonConditionId");

CREATE INDEX "IX_SFOperationCommands_SwitchoverFormCommonOperationId" ON "SFOperationCommands" ("SwitchoverFormCommonOperationId");

CREATE INDEX "IX_SFConditionCommands_SwitchoverFormCommonConditionId" ON "SFConditionCommands" ("SwitchoverFormCommonConditionId");

CREATE INDEX "IX_SFFormAlarms_SwitchoverFormId" ON "SFFormAlarms" ("SwitchoverFormId");

CREATE INDEX "IX_SFFormAlarmCommands_SwitchoverFormAlarmId" ON "SFFormAlarmCommands" ("SwitchoverFormAlarmId");

CREATE INDEX "IX_SFFormCommonAlarmCommands_SwitchoverFormCommonAlarmId" ON "SFFormCommonAlarmCommands" ("SwitchoverFormCommonAlarmId");

COMMIT;

