var TrendSettings = (function () {
    function TrendSettings() {
        this.id = '';
        this.parameterId = '';
        this.graphType = 0;
        this.pointType = 0;
        this.autoZoom = false;
        this.yMin = {};
        this.yMax = {};
        this.autoZoomYMin = 0;
        this.autoZoomYMax = 0;
        this.userId = '';
    }
    return TrendSettings;
}());
var Graph = (function () {
    function Graph(id, name, settings) {
        this.id = id;
        this.name = name;
        this.settings = settings;
    }
    return Graph;
}());
app.controller('ReportTreeViewerController', function ($scope, $rootScope, $http, $modal, clientSettings, notificationService, guid, blockUI, authentication, permissionService, language) {
    $scope.dataNodes = [];
    $scope.dataAddedElements = [];
    $scope.addedElements = [];
    $scope.graphMap = {};
    $scope.visibleTree = true;
    $scope.isOneY = true;
    $scope.nameSearch = '';
    $scope.maxDate = new Date();
    $scope.oneYDefaultMin = 0;
    $scope.oneYDefaultMax = 100;
    $scope.periods = {
        data: [
            { id: 0, name: language.getElementValue('reportTrendsViewPointPeriodTypeDayHdr') },
            { id: 1, name: language.getElementValue('reportTrendsViewPointPeriodTypeMonthHdr') },
            { id: 2, name: language.getElementValue('reportTrendsViewPointPeriodTypeQuarterlyHdr') },
            { id: 3, name: language.getElementValue('reportTrendsViewPointPeriodTypeYearHdr') },
            { id: 4, name: language.getElementValue('reportTrendsViewPointPeriodTypePeriodHdr') },
        ],
        selected: {},
    };
    $scope.periods.selected = $scope.periods.data[0];
    $scope.tree = new SmsTree();
    $scope.columns = [new SmsTreeColumn(language.getElementValue('titleHdr'), 'Text')];
    $scope.startingData = new SmsTreeDataItem('1', language.getElementValue('loadingHdr'));
    $scope.plugins = ['types', 'wholerow', 'grid', 'checkbox'];
    $scope.types = new SmsTypes('glyphicon glyphicon-none', 'fa fa-folder', 'fa fa-file-o');
    $scope.expandLevel = 0;
    var createTree = function (tree) {
        var toDelete = [];
        _.each(tree, function (item) {
            if (item.children.length != 0) {
                item.type = 'folder';
                if (!_.isNull(item.uniqueGuid) &&
                    !authentication.hasPermission('ReportView_' + item.uniqueGuid) &&
                    !authentication.hasPermission('ReportEdit_' + item.uniqueGuid)) {
                    toDelete.push(item.id);
                    return;
                }
                createTree(item.children);
            }
            else {
                item.data = {
                    templateDbId: item.templateDbId,
                    uniqueGuid: item.uniqueGuid,
                };
                item.type = 'file';
                $scope.dataNodes[item.templateDbId] = {
                    id: item.id,
                    name: item.text,
                    templateDbId: item.templateDbId,
                };
                delete item.children;
            }
            if (item.type === 'folder' && (_.isUndefined(item.children) || item.children.length === 0)) {
                toDelete.push(item.id);
            }
            delete item.templateDbId;
        });
        _.each(toDelete, function (id) {
            var index = _.findIndex(tree, function (e) {
                return e.id === id;
            });
            if (index !== -1) {
                tree.splice(index, 1);
            }
        });
    };
    var unregistrationJstreeReadyWatchFunc = $scope.$on('jstreeReady', function (event, treeId) {
        if ($scope.tree.element.attr('id') == treeId) {
            $scope.onLoadTree();
        }
    });
    $scope.onLoadTree = function () {
        $http.get(clientSettings.getServerInstance() + '/ReportTreeViewer/GetTree').then(function (response) {
            createTree(response.data);
            $scope.jsonTree = JSON.stringify(response.data);
            if ($scope.nameSearch == '') {
                $scope.tree.element.jstree().settings.core.data = response.data;
            }
            else {
                $scope.filterTreeByName(response.data);
                $scope.tree.element.jstree().settings.core.data =
                    response.data.length != 0
                        ? response.data
                        : { id: '1', text: language.getElementValue('elementsNotFoundHdr'), type: 'none' };
            }
            $scope.tree.element.jstree().uncheck_all();
            $scope.tree.element.jstree('refresh');
            $scope.updateUILinks();
            $scope.onDeleteElements();
        }, function (data) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), data);
        });
    };
    $scope.hideTree = function () {
        if ($scope.visibleTree) {
            $scope.divToolBarTree.css('overflow', 'hidden');
            $scope.divTree.animate({ width: '-=500px' }, 400, function () {
                $scope.divTrends.css('width', 'calc(100% - 40px)');
                if (_.isDefined($scope.chartjs)) {
                    $scope.chartjs.render();
                    $scope.chartjs.resize();
                }
            });
            $scope.visibleTree = false;
        }
        else {
            $scope.divTree.animate({ width: '+=500px' }, 400, function () {
                $scope.divToolBarTree.css('overflow', 'inherit');
                $scope.divTrends.css('width', 'calc(100% - 540px)');
                if ($scope.chart != undefined)
                    $scope.chart.validateNow();
            });
            $scope.visibleTree = true;
        }
    };
    $scope.onDeleteElements = function () {
        $scope.buttonDeleteElements.blur();
        $scope.addedElements = [];
        $scope.dataAddedElements = [];
        $scope.chartData = [];
        $scope.tableData = [];
        $scope.graphMap = {};
        if (_.isDefined($scope.chartjs)) {
            $scope.chartjs.clear();
            $scope.chartjs.destroy();
        }
        $scope.createParametersTable();
    };
    $scope.loadAddedElementsData = function () {
        var endTime = $scope.periods.selected.id != 4 ? $scope.mainEndDate.addSeconds(-1) : $scope.mainEndDate;
        blockUI.start();
        $http
            .post(clientSettings.getServerInstance() + '/ReportTreeViewer/GetValues', {
            jsonParameters: JSON.stringify($scope.addedElements),
            startTime: $scope.mainStartDate,
            endTime: endTime,
        })
            .then(function (response) {
            $scope.graphMap = {};
            $scope.dataAddedElements = response.data;
            var errorParameters = [];
            var graphsSettings = _.isUndefined(localStorage['jsonGraphsSettings'])
                ? []
                : JSON.parse(localStorage['jsonGraphsSettings']);
            _.each($scope.dataAddedElements, function (e) {
                var _a;
                var graphSettings = _.find(graphsSettings, function (settings) {
                    var _a;
                    return (settings.parameterId === e.templateDbId + '-' + e.name &&
                        settings.userId === ((_a = authentication.user) === null || _a === void 0 ? void 0 : _a.id));
                });
                if (_.isUndefined(graphSettings) || _.isNull(graphSettings)) {
                    e.settings = new TrendSettings();
                    (e.settings.id = guid.new()), (e.settings.parameterId = e.templateDbId + '-' + e.name);
                    e.settings.graphType = 0;
                    e.settings.pointType = 0;
                    e.settings.autoZoom = true;
                    e.settings.userId = (_a = authentication.user) === null || _a === void 0 ? void 0 : _a.id;
                }
                else {
                    e.settings = graphSettings;
                }
                var values = _.map(e.values, function (v) {
                    return v.value;
                });
                var min = _.min(values);
                var max = _.max(values);
                if (min >= 0) {
                    e.settings.yMin = 0;
                    e.settings.yMax = $scope.getYAxisLimitValue(max);
                }
                else {
                    e.settings.yMin = -1 * $scope.getYAxisLimitValue(min);
                    e.settings.yMax = max >= 0 ? $scope.getYAxisLimitValue(max) : 0;
                }
                e.settings.autoZoomYMin = min;
                e.settings.autoZoomYMax = max;
                if (min == max) {
                    e.settings.autoZoomYMin = min - 1;
                    e.settings.autoZoomYMax = max + 1;
                }
                if (e.hasError) {
                    errorParameters.push(e.name);
                }
            });
            $scope.createChartData();
            if ($scope.tabTrends.hasClass('active')) {
                $scope.createChartJs();
            }
            else {
                $scope.createParametersTable();
            }
            blockUI.stop();
        }, function (data) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), data);
            blockUI.stop();
        });
    };
    $scope.createChartData = function () {
        $scope.chartData = [];
        var sortFunc = function (a, b) {
            var aDate = moment(a.date, a.format);
            var bDate = moment(b.date, b.format);
            return aDate.isSame(bDate) ? (a.date.length < b.date.length ? 1 : -1) : aDate.isAfter(bDate) ? 1 : -1;
        };
        var groupData = _.chain($scope.dataAddedElements)
            .map(function (e) {
            return _.map(e.values, function (i) {
                return {
                    ident: e.templateDbId + '-' + e.name,
                    date: i.date,
                    value: i.value,
                    format: 'DD.MM.YYYY HH:mm',
                };
            });
        })
            .flatten()
            .groupBy('date')
            .value();
        $scope.chartData = Object.keys(groupData)
            .map(function (ts) {
            var result = {
                date: ts,
                format: 'DD.MM.YYYY HH:mm',
            };
            for (var i = 0; i < groupData[ts].length; i++) {
                result[groupData[ts][i].ident] = groupData[ts][i].value;
            }
            return result;
        })
            .sort(sortFunc);
    };
    var updateYAxis = function () {
        var visibledGraphs = [];
        _.each($scope.graphMap, function (value, key) {
            if (value == true)
                visibledGraphs.push(key);
        });
        if (visibledGraphs.length == 1) {
            var visibledParam = _.find($scope.dataAddedElements, function (item) {
                return visibledGraphs[0] == 'g' + item.templateDbId + '-' + item.name;
            });
            $scope.chart.valueAxes[0].minimum = visibledParam.settings.autoZoom
                ? visibledParam.settings.autoZoomYMin
                : visibledParam.settings.yMin;
            $scope.chart.valueAxes[0].maximum = visibledParam.settings.autoZoom
                ? visibledParam.settings.autoZoomYMax
                : visibledParam.settings.yMax;
        }
        else {
            $scope.chart.valueAxes[0].minimum = $scope.oneYDefaultMin;
            $scope.chart.valueAxes[0].maximum = $scope.oneYDefaultMax;
        }
    };
    var getRandomColor = function () {
        var letters = '0123456789ABCDEF'.split('');
        var color = '#';
        for (var i = 0; i < 6; i++) {
            color += letters[Math.floor(Math.random() * 16)];
        }
        return color;
    };
    var getRandomColors = function (count) {
        var defaultColors = [
            '#ff6384',
            '#36a2eb',
            '#ffcd56',
            '#4caf50',
            '#4bc0c0',
            '#6372c1',
            '#9966ff',
            '#c9cbcf',
            '#ff9f40',
            '#f44336',
        ];
        var result = [];
        for (var i = 0; i < count; i++) {
            if (i < defaultColors.length) {
                result.push(defaultColors[i]);
            }
            else {
                result.push(getRandomColor());
            }
        }
        return result;
    };
    var getDatasetPointType = function (trendSettings) {
        switch (trendSettings.pointType) {
            case 4:
            case 7:
                return 'rect';
            case 5:
            case 8:
                return 'circle';
            case 6:
            case 9:
                return 'triangle';
            default:
                return 'rectRot';
        }
    };
    $scope.createChartJs = function () {
        if (!_.any($scope.dataAddedElements)) {
            return;
        }
        $scope.divCheckboxes.show();
        $scope.tabset.css('margin-top', '0');
        if ($scope.visibleTree) {
            $scope.divTrends.css('width', $scope.windowWidth - 620 + 'px');
            $scope.divChartJs.css('width', $scope.windowWidth - 620 + 'px');
        }
        else {
            $scope.divTrends.css('width', $scope.windowWidth - 120 + 'px');
            $scope.divChartJs.css('width', $scope.windowWidth - 120 + 'px');
        }
        var canvas = $scope.divChartJs.get(0);
        var context = canvas.getContext('2d');
        var labels = [];
        var datasets = [];
        var colors = getRandomColors($scope.dataAddedElements.length);
        var sortFunc = function (a, b) {
            var format = 'DD.MM.YYYY HH:mm';
            var aDate = moment(a, format);
            var bDate = moment(b, format);
            return aDate.isSame(bDate) ? (a.length < b.length ? 1 : -1) : aDate.isAfter(bDate) ? 1 : -1;
        };
        _.each($scope.dataAddedElements, function (parameter, index) {
            if (!_.any(parameter.values)) {
                return;
            }
            var dates = _.chain(parameter.values)
                .map(function (valueInfo) {
                return valueInfo.date;
            })
                .filter(function (date) {
                return !_.contains(labels, date);
            })
                .value();
            labels = labels.concat(dates);
            var dataset = {
                label: parameter.templateDbId + '-' + parameter.name,
                data: _.map(parameter.values, function (valueInfo) {
                    return { x: valueInfo.date, y: valueInfo.value };
                }),
                borderColor: colors[index],
                lineTension: 0,
                pointHoverRadius: parameter.settings.pointType == 0 ? 0 : 6,
                pointHoverBorderWidth: 3,
                pointBorderWidth: 2,
                borderWidth: 2,
                fill: false,
                showLine: true,
                steppedLine: false,
                pointStyle: getDatasetPointType(parameter.settings),
                pointRadius: parameter.settings.pointType == 0 ? 0 : 3,
                backgroundColor: colors[index],
                pointBackgroundColor: parameter.settings.pointType < 7 ? 'transparent' : colors[index],
            };
            switch (parameter.settings.graphType) {
                case 1:
                    dataset.showLine = false;
                    break;
                case 2:
                    dataset.steppedLine = true;
            }
            datasets.push(dataset);
        });
        labels = labels.sort(sortFunc);
        var zoomPluginOptions = {
            pan: {
                enabled: true,
                mode: 'xy',
            },
            zoom: {
                enabled: true,
                mode: 'xy',
                rangeMin: {
                    x: null,
                    y: null,
                },
                rangeMax: {
                    x: null,
                    y: null,
                },
                speed: 0.1,
            },
            yTicks: undefined,
        };
        var config = {
            type: 'line',
            data: {
                labels: labels,
                datasets: datasets,
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                tooltips: {
                    intersect: false,
                    mode: 'index',
                    enabled: true,
                },
                legend: {
                    display: true,
                    position: 'right',
                    labels: {
                        fontColor: '#000000',
                        fontFamily: 'OpenSansRegular,Roboto',
                        fontSize: 13,
                    },
                    fullWidth: false,
                },
                scales: {
                    xAxes: [
                        {
                            display: true,
                            ticks: { fontColor: '#000000' },
                            gridLines: { zeroLineWidth: 1, zeroLineColor: '#000000' },
                        },
                    ],
                    yAxes: [
                        {
                            display: true,
                            ticks: { fontColor: '#000000' },
                            gridLines: { zeroLineWidth: 1, zeroLineColor: '#000000' },
                        },
                    ],
                },
                plugins: {
                    zoom: zoomPluginOptions,
                },
            },
            plugins: [
                {
                    afterLayout: function (chart, options) {
                        var yTicks = chart.scales['y-axis-0'].ticks;
                        if (_.isUndefined(zoomPluginOptions.yTicks)) {
                            zoomPluginOptions.yTicks = _.clone(yTicks);
                        }
                        var xTicksLength = chart.scales['x-axis-0'].ticks.length;
                        var xLabels = chart.data.labels.length;
                        if (xTicksLength != xLabels || !_.isEqual(zoomPluginOptions.yTicks, yTicks)) {
                            $('#chartZoomOut').show();
                        }
                        else {
                            $('#chartZoomOut').hide();
                        }
                    },
                },
            ],
        };
        var autoZoomDisabledParameters = _.filter($scope.dataAddedElements, function (parameter) { return !parameter.settings.autoZoom; });
        if (autoZoomDisabledParameters.length != 0) {
            config.options.scales.yAxes[0].ticks.min = _.min(autoZoomDisabledParameters, function (autoZoomDisabledParameters) { return autoZoomDisabledParameters.settings.yMin; }).settings.yMin;
            config.options.scales.yAxes[0].ticks.max = _.max(autoZoomDisabledParameters, function (autoZoomDisabledParameters) { return autoZoomDisabledParameters.settings.yMax; }).settings.yMax;
        }
        if (_.isDefined($scope.chartjs)) {
            $scope.chartjs.destroy();
        }
        $scope.chartjs = new Chart(context, config);
    };
    $scope.zoomOut = function () {
        if (_.isDefined($scope.chartjs)) {
            $scope.chartjs.resetZoom();
        }
    };
    $scope.createParametersTable = function () {
        $scope.divCheckboxes.hide();
        $scope.tabset.css('margin-top', '0');
        $scope.tableData = [];
        _.each($scope.chartData, function (item) {
            var data = [];
            if (_.isUndefined($scope.dataAddedElements) || _.isNull($scope.dataAddedElements))
                return;
            for (var i = 0; i < $scope.dataAddedElements.length; i++) {
                var ident = $scope.dataAddedElements[i].templateDbId + '-' + $scope.dataAddedElements[i].name;
                data.push({
                    ident: ident,
                    param: $scope.dataAddedElements[i].name,
                    value: '',
                });
                if (!_.isUndefined(item[ident])) {
                    data[i].value = item[ident];
                }
            }
            $scope.tableData.push({
                date: item.date,
                data: data,
            });
        });
        if ($scope.visibleTree) {
            $scope.divTrends.css('width', 'calc(100% - 540px)');
        }
        else {
            $scope.divTrends.css('width', 'calc(100% - 40px)');
        }
    };
    $scope.onOneY = function () {
        $scope.isOneY = true;
    };
    $scope.onSomeY = function () {
        $scope.isOneY = false;
    };
    var unregistrationIsOneYWatchFunc = $scope.$watch('isOneY', function (after, before) {
        if (after == before)
            return;
        $scope.createChartJs();
    });
    $scope.getYAxisLimitValue = function (value) {
        value = Math.abs(value);
        var k;
        if (value <= 200) {
            k = ((value / 50) | 0) + 1;
            return 50 * k;
        }
        else if (value <= 550) {
            k = ((value / 100) | 0) + 1;
            return 100 * k;
        }
        else if (value <= 1000) {
            k = ((value / 500) | 0) + 1;
            return 500 * k;
        }
        else {
            k = ((value / 1000) | 0) + 1;
            return 1000 * k;
        }
    };
    var unregistrationNameSearchWatchFunc = $scope.$watch('nameSearch', function (after, before) {
        if (before == after)
            return;
        $scope.tempTree = JSON.parse($scope.jsonTree);
        if (after == '') {
            $scope.tree.element.jstree().settings.core.data = $scope.tempTree;
        }
        else {
            $scope.filterTreeByName($scope.tempTree);
            $scope.tree.element.jstree().settings.core.data =
                $scope.tempTree.length != 0
                    ? $scope.tempTree
                    : { id: '1', text: language.getElementValue('elementsNotFoundHdr'), type: 'none' };
        }
        $scope.tree.element.jstree('refresh');
    });
    $scope.filterTreeByName = function (tree, chapterMatched, templateMatched) {
        if (chapterMatched === void 0) { chapterMatched = false; }
        if (templateMatched === void 0) { templateMatched = false; }
        var toDelete = [];
        for (var i = 0; i < tree.length; i++) {
            if (tree[i].children != undefined) {
                if (!_.isNull(tree[i].text) &&
                    tree[i].text.toLowerCase().indexOf($scope.nameSearch.toLowerCase()) != -1) {
                    if (_.isNull(tree[i].uniqueGuid)) {
                        chapterMatched = true;
                    }
                    else {
                        templateMatched = true;
                    }
                }
                else {
                    if (_.isNull(tree[i].uniqueGuid)) {
                        chapterMatched = false;
                    }
                    else {
                        templateMatched = false;
                    }
                }
                $scope.filterTreeByName(tree[i].children, chapterMatched, templateMatched);
                if (tree[i].children.length === 0) {
                    tree.splice(i, 1);
                    i--;
                }
            }
            else {
                if (!_.isNull(tree[i].text) &&
                    tree[i].text.toLowerCase().indexOf($scope.nameSearch.toLowerCase()) != -1) {
                    continue;
                }
                else {
                    toDelete.push(tree[i].id);
                }
            }
        }
        if (((templateMatched || chapterMatched) && toDelete.length !== tree.length) ||
            (!templateMatched && !chapterMatched)) {
            _.each(toDelete, function (id) {
                var index = _.findIndex(tree, function (e) {
                    return e.id === id;
                });
                if (index !== -1) {
                    tree.splice(index, 1);
                }
            });
        }
    };
    $scope.updateUILinks = function () {
        $scope.divToolBarTree = $('#divToolBarTree');
        $scope.divTree = $('#divTree');
        $scope.divTrends = $('#divTrends');
        $scope.divCheckboxes = $('#divCheckboxes');
        $scope.tabset = $('#tabset');
        $scope.tabTrends = $('#tabTrends');
        $scope.buttonDeleteElements = $('#buttonDeleteElements');
        $scope.buttonApplyChanges = $('#buttonApplyChanges');
        $scope.divChartJs = $('#divChart');
    };
    var unregistrationPeriodWatchFunc = $scope.$watch('periods.selected', function (after, before) {
        if (after == before)
            return;
        switch (after.id) {
            case 0:
                {
                    $scope.startDate = new Date().getBeginDay();
                    $scope.endDate = new Date().addDays(1).getBeginDay();
                }
                break;
            case 1:
                {
                    $scope.startDate = new Date().getBeginMonth();
                    $scope.endDate = new Date().addMonths(1).getBeginMonth();
                }
                break;
            case 2:
                {
                    var quarter = Math.floor(new Date().getMonth() / 3 + 1);
                    $scope.startDate = new Date();
                    $scope.startDate.setMonth(quarter * 3 - 3);
                    $scope.startDate = $scope.startDate.getBeginMonth();
                    $scope.endDate = $scope.startDate.clone().addMonths(3);
                }
                break;
            case 3:
                {
                    $scope.startDate = new Date().getBeginYear();
                    $scope.endDate = new Date().addYears(1).getBeginYear();
                }
                break;
            default:
                {
                    $scope.startDate = new Date().getBeginDay();
                    $scope.endDate = new Date().addDays(1).getBeginDay();
                }
                break;
        }
    });
    $scope.startDate = new Date().getBeginDay();
    $scope.mainStartDate = new Date().getBeginDay();
    $scope.onStartDateChange = function () {
        switch ($scope.periods.selected.id) {
            case 0:
                {
                    $scope.endDate = $scope.startDate.clone().addDays(1).getBeginDay();
                }
                break;
            case 1:
                {
                    $scope.endDate = $scope.startDate.clone().addMonths(1).getBeginMonth();
                }
                break;
            case 2:
                {
                    $scope.endDate = $scope.startDate.clone().addMonths(3).getBeginMonth();
                }
                break;
            case 3:
                {
                    $scope.endDate = $scope.startDate.clone().addYears(1).getBeginYear();
                }
                break;
        }
    };
    $scope.endDate = new Date().addDays(1).getBeginDay();
    $scope.mainEndDate = new Date().addDays(1).getBeginDay();
    var unregistrationEndDateOnFunc = $scope.$on('dateTimePicker:endDatePicker.dateTimeChanged', function (event, data) {
        $scope.endDate = data;
    });
    $scope.decDay = function () {
        $scope.startDate = $scope.startDate.addDays(-1);
        $scope.endDate = $scope.endDate.addDays(-1);
    };
    $scope.incDay = function () {
        var newStartDate = $scope.startDate.clone().addDays(1);
        if (newStartDate < new Date()) {
            $scope.startDate = newStartDate;
            $scope.endDate = $scope.endDate.addDays(1);
        }
    };
    $scope.decMonth = function () {
        $scope.startDate = $scope.startDate.addMonths(-1);
        $scope.endDate = $scope.endDate.addMonths(-1);
    };
    $scope.incMonth = function () {
        var newStartDate = $scope.startDate.clone().addMonths(1);
        if (newStartDate < new Date()) {
            $scope.startDate = newStartDate;
            $scope.endDate = $scope.endDate.addMonths(1);
        }
    };
    $scope.decQuarter = function () {
        $scope.startDate = $scope.startDate.addMonths(-3);
        $scope.endDate = $scope.endDate.addMonths(-3);
    };
    $scope.incQuarter = function () {
        var newStartDate = $scope.startDate.clone().addMonths(3);
        if (newStartDate < new Date()) {
            $scope.startDate = newStartDate;
            $scope.endDate = $scope.endDate.addMonths(3);
        }
    };
    $scope.decYear = function () {
        $scope.startDate = $scope.startDate.addYears(-1);
        $scope.endDate = $scope.endDate.addYears(-1);
    };
    $scope.incYear = function () {
        var newStartDate = $scope.startDate.clone().addYears(1);
        if (newStartDate < new Date()) {
            $scope.startDate = newStartDate;
            $scope.endDate = $scope.endDate.addYears(1);
        }
    };
    $scope.onApplyChanges = function () {
        $scope.buttonApplyChanges.blur();
        $scope.addedElements = [];
        _.each($scope.tree.selectedElements, function (e) {
            var node = $scope.tree.element.jstree().get_node(e);
            if (node.type !== 'file' || node.data.templateDbId == undefined)
                return;
            var reportParams = _.find($scope.addedElements, function (item) {
                return item.templateDbId === node.data.templateDbId;
            });
            if (reportParams == undefined) {
                $scope.addedElements.push({
                    templateDbId: node.data.templateDbId,
                    uniqueGuid: node.data.uniqueGuid,
                    parameterIdents: [node.text],
                });
            }
            else {
                reportParams.parameterIdents.push(node.text);
            }
        });
        $scope.mainStartDate = $scope.startDate.clone();
        $scope.mainEndDate = $scope.endDate.clone();
        if (!_.isUndefined($scope.addedElements) &&
            !_.isNull($scope.addedElements) &&
            $scope.addedElements.length != 0) {
            $scope.loadAddedElementsData();
        }
    };
    $scope.onGraphsSettings = function () {
        $modal
            .open({
            templateUrl: 'ng1/dist/src/ReportTreeViewer/TrendSettings.html',
            controller: 'TrendSettingsController',
            resolve: {
                graphs: function () {
                    return _.map($scope.dataAddedElements, function (item) {
                        return new Graph(item.templateDbId + '-' + item.name, item.name, item.settings);
                    });
                },
            },
        })
            .result.then(function (graphs) {
            if (graphs != null) {
                if (_.isUndefined(localStorage['jsonGraphsSettings'])) {
                    localStorage.setItem('jsonGraphsSettings', JSON.stringify(_.map(graphs, function (graph) {
                        return graph.settings;
                    })));
                }
                else {
                    var graphsSettings_1 = JSON.parse(localStorage['jsonGraphsSettings']);
                    _.each(graphs, function (graph) {
                        var existedSettingsIndex = _.findIndex(graphsSettings_1, function (s) {
                            return (s.parameterId == graph.settings.parameterId &&
                                s.userId == graph.settings.userId);
                        });
                        if (existedSettingsIndex !== -1) {
                            graphsSettings_1.splice(existedSettingsIndex, 1);
                        }
                        graphsSettings_1.push(graph.settings);
                    });
                    localStorage['jsonGraphsSettings'] = JSON.stringify(graphsSettings_1);
                }
                _.each($scope.dataAddedElements, function (item) {
                    var graph = _.find(graphs, function (g) { return g.id == item.templateDbId + '-' + item.name; });
                    item.settings = graph.settings;
                });
                $scope.createChartJs();
            }
        }, function () { });
    };
    $scope.onWindowResize = function (newValue, oldValue) {
        $scope.windowHeight = newValue.h;
        $scope.windowWidth = newValue.w;
        $scope.trendsSizeWithOffset = function (heightOffset, widthOffset) {
            var wOffset = $scope.visibleTree ? widthOffset : widthOffset - 550;
            return $.extend($scope.heightWithOffset(heightOffset), $scope.widthWithOffset(wOffset));
        };
        $scope.heightWithOffset = function (heightOffset) { return ({
            height: newValue.h - heightOffset + 'px',
        }); };
        $scope.widthWithOffset = function (widthOffset) { return ({
            width: newValue.w - widthOffset + 'px',
        }); };
        if (_.isDefined($scope.chartjs)) {
            $scope.chartjs.resize();
            $scope.chartjs.render();
        }
    };
    var unregistrationDestroyFunc = $scope.$on('$destroy', function () {
        unregistrationJstreeReadyWatchFunc();
        unregistrationDestroyFunc();
        unregistrationPeriodWatchFunc();
        unregistrationEndDateOnFunc();
        unregistrationIsOneYWatchFunc();
        unregistrationNameSearchWatchFunc();
    });
});
