var SwitchoverFormConditionExportModalCtrl = (function () {
    function SwitchoverFormConditionExportModalCtrl(scope, $modalInstance, conditions) {
        this.scope = scope;
        this.$modalInstance = $modalInstance;
        this.conditions = conditions;
        this.isAllConditionsSelected = true;
        this.isNoneConditionsSelected = false;
        this.scope.ctrl = this;
        this.conditionOptions = _.map(conditions, function (t) {
            return {
                description: t.description,
                id: t.id,
                isSelected: true,
            };
        });
    }
    SwitchoverFormConditionExportModalCtrl.prototype.changeAllConditionOptionsStatus = function () {
        var currentStatus = this.isAllConditionsSelected;
        _.forEach(this.conditionOptions, function (o) {
            o.isSelected = !currentStatus;
        });
        this.isAllConditionsSelected = !currentStatus;
        this.isNoneConditionsSelected = currentStatus;
    };
    SwitchoverFormConditionExportModalCtrl.prototype.changeOptionSelectStatus = function (option) {
        if (_.isDefined(option)) {
            option.isSelected = !option.isSelected;
        }
        this.isAllConditionsSelected = _.all(this.conditionOptions, function (o) { return o.isSelected; });
        this.isNoneConditionsSelected = _.all(this.conditionOptions, function (o) { return !o.isSelected; });
    };
    SwitchoverFormConditionExportModalCtrl.prototype.ok = function () {
        this.$modalInstance.close({
            ids: _.map(_.where(this.conditionOptions, function (o) { return o.isSelected; }), function (o) { return o.id; }),
            format: 7,
        });
    };
    SwitchoverFormConditionExportModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    SwitchoverFormConditionExportModalCtrl.$inject = ['$scope', '$modalInstance', 'conditions'];
    return SwitchoverFormConditionExportModalCtrl;
}());
angular.module('kamhpp').controller('switchoverFormConditionExportModalCtrl', SwitchoverFormConditionExportModalCtrl);
