var SwitchoverFormTemplateEditOperationModalCtrl = (function () {
    function SwitchoverFormTemplateEditOperationModalCtrl($rootScope, $scope, $modal, $modalService, authentication, language, switchoverFormConfigurationProvider, notificationService, switchoverFormsCkeditorConfigurationProvider, removeHtmlFilter, operation, operations, isEditable, isTypical) {
        var _this = this;
        var _a;
        this.$rootScope = $rootScope;
        this.$scope = $scope;
        this.$modal = $modal;
        this.$modalService = $modalService;
        this.authentication = authentication;
        this.language = language;
        this.switchoverFormConfigurationProvider = switchoverFormConfigurationProvider;
        this.notificationService = notificationService;
        this.switchoverFormsCkeditorConfigurationProvider = switchoverFormsCkeditorConfigurationProvider;
        this.removeHtmlFilter = removeHtmlFilter;
        this.operation = operation;
        this.operations = operations;
        this.isEditable = isEditable;
        this.isTypical = isTypical;
        this.operationTypes = [
            {
                id: 1,
                name: this.language.getElementValue('switchoverFormsAutomaticTypeMsg'),
            },
            {
                id: 0,
                name: this.language.getElementValue('switchoverFormsManualTypeMsg'),
            },
            { id: 2, name: this.language.getElementValue('switchoverFormsTextTypeMsg') },
        ];
        this.commandSources = [
            { id: 1, name: this.language.getElementValue('winccoaHdr') },
            { id: 0, name: this.language.getElementValue('opcSourceHdr') },
        ];
        this.commandTypes = [
            {
                id: 0,
                name: this.language.getElementValue('switchoverFormsCommandTypeVerifyMsg'),
            },
            {
                id: 1,
                name: this.language.getElementValue('switchoverFormsCommandTypeWriteMsg'),
            },
            {
                id: 2,
                name: this.language.getElementValue('switchoverFormsCommandTypeVerifyBitMsg'),
            },
            {
                id: 3,
                name: this.language.getElementValue('switchoverFormsCommandTypeWriteBitMsg'),
            },
        ];
        this.opcConnectionGuid = '';
        this.winccOaConnectionGuid = '';
        this.$scope.ctrl = this;
        if (_.isUndefined(this.operation)) {
            this.operation = {
                id: 0,
                description: this.getDescription(this.language.getElementValue('switchoverFormOperationHdr'), ((_a = this.operations) === null || _a === void 0 ? void 0 : _a.length) + 1),
                type: 0,
                isTypical: true,
                commands: [],
            };
        }
        this.selectedOperation = angular.copy(this.operation);
        this.selectedOperation.commands = _.sortBy(this.selectedOperation.commands, function (c) { return c.orderNumber; });
        this.editorConfiguration = this.switchoverFormsCkeditorConfigurationProvider.getStepFullEditorConfiguration();
        this.editorConfiguration.config.readOnly = !this.isEditable;
        this.switchoverFormConfigurationProvider
            .getSwitchoverFormConfiguration()
            .then(function (data) {
            _this.opcConnectionGuid = data.opcConnectionGuid;
            _this.winccOaConnectionGuid = data.winccOaConnectionGuid;
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), result);
        });
    }
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.isAutomatic = function () {
        return this.selectedOperation.type === 1;
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.ok = function () {
        var _this = this;
        if (!this.isValid()) {
            this.notificationService.warnMessage(this.language.getElementValue('switchoverFormsErrorAllFieldsMustBeFilledMsg'));
            return;
        }
        var pureDescription = this.removeHtmlFilter(this.selectedOperation.description);
        var duplicate = this.isTypical ? _.find(this.operations, function (operation) { return _this.removeHtmlFilter(operation.description) === pureDescription; }) : undefined;
        if (_.isDefined(duplicate)) {
            this.$modalService
                .open({
                templateUrl: 'ng1/dist/src/Common/Components/YesNoModal.html',
                controller: 'yesNoModalCtrl',
                backdrop: 'static',
                resolve: {
                    header: function () { return _this.language.getElementValue('switchoverFormsOperationExistsHdr'); },
                    body: function () { return _this.language.getElementValue('switchoverFormsOperationExistsMsg'); },
                },
            })
                .result.then(function () {
                if (_this.selectedOperation.type !== 1) {
                    _this.selectedOperation.commands = [];
                }
                _this.$modal.close(_this.selectedOperation);
            }, function () { });
        }
        else {
            if (this.selectedOperation.type !== 1) {
                this.selectedOperation.commands = [];
            }
            this.$modal.close(this.selectedOperation);
        }
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.cancel = function () {
        this.$modal.dismiss();
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.selectTag = function (command) {
        var tagTreeTypes = command.source === 0
            ? [TagTreeType.Opc]
            : [TagTreeType.WinccOaCns, TagTreeType.WinccOaPara];
        var connectionGuid = command.source === 0
            ? this.opcConnectionGuid
            : this.winccOaConnectionGuid;
        var modalInstance = this.$modalService.open({
            templateUrl: 'ng1/dist/src/TagsTree/TagsTreeModal.html',
            controller: 'tagsTreeModalCtrl',
            windowClass: 'app-modal-window modal-wide modal-width-100 modal-tab-window level-two',
            backdrop: 'static',
            resolve: {
                connectionGuid: function () { return connectionGuid; },
                isMultiselectEnabled: function () { return false; },
                tagTreeTypes: function () { return tagTreeTypes; },
                tagAddress: function () { return command.tagAddress; }
            },
        });
        modalInstance.result.then(function (tags) {
            command.name = tags[0].name;
            command.tagAddress = tags[0].address;
            command.type = command.source === 1 && command.tagAddress.contains('_CMD')
                ? 1
                : 0;
        });
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.isWinccOaSource = function (commandSource) {
        return commandSource === 1;
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.isTagExists = function (command) {
        var _this = this;
        this.switchoverFormConfigurationProvider
            .isTagExists(command.tagAddress, command.source)
            .then(function (isTagExists) {
            if (isTagExists) {
                _this.notificationService.showMessage(_this.language.getElementValue('tagAddressIsExistMsg'));
            }
            else {
                _this.notificationService.errorMessage(_this.language.getElementValue('tagAddressIsNotExistMsg'));
            }
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('errorCheckTagAddressMsg'), result);
        });
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.isBitCommandType = function (command) {
        return (command.type === 2 ||
            command.type === 3);
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.onChangeBitInfo = function (command) {
        command.value = command.bitNumber + ';' + command.bitValue;
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.onChangeCommandType = function (command) {
        if (this.isBitCommandType(command)) {
            command.value = command.bitNumber + ';' + command.bitValue;
        }
        else {
            command.value = '1';
        }
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.insert = function () {
        var _this = this;
        var source = !_.isEmpty(this.winccOaConnectionGuid)
            ? 1
            : 0;
        var tagTreeTypes = source === 1
            ? [TagTreeType.WinccOaCns, TagTreeType.WinccOaPara]
            : [TagTreeType.Opc];
        var connectionGuid = source === 1
            ? this.winccOaConnectionGuid
            : this.opcConnectionGuid;
        var modalInstance = this.$modalService.open({
            templateUrl: 'ng1/dist/src/TagsTree/TagsTreeModal.html',
            controller: 'tagsTreeModalCtrl',
            windowClass: 'app-modal-window modal-wide modal-width-100 modal-tab-window level-two',
            backdrop: 'static',
            resolve: {
                connectionGuid: function () { return connectionGuid; },
                isMultiselectEnabled: function () { return true; },
                tagTreeTypes: function () { return tagTreeTypes; },
                tagAddress: function () { return undefined; },
            },
        });
        modalInstance.result.then(function (tags) {
            var _a;
            var orderNumber = _this.selectedOperation.commands.length === 0 ? 0 : _.last(_this.selectedOperation.commands).orderNumber + 1;
            var commands = _.map(tags, function (tag, index) {
                return {
                    id: 0,
                    name: tag.name,
                    type: source === 1 && tag.address.contains('_CMD')
                        ? 1
                        : 0,
                    source: source,
                    orderNumber: orderNumber + index,
                    tagAddress: tag.address,
                    value: '1',
                    switchoverFormCommonOperationId: _this.operation.id,
                    bitValue: 0,
                    bitNumber: 0,
                };
            });
            (_a = _this.selectedOperation.commands).push.apply(_a, commands);
            _this.selectedOperation.type = 1;
        });
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.refreshDescription = function () {
        var commandNames = _.map(this.selectedOperation.commands, function (command) { return command.name.length > 0 && command.name[0] === '.'
            ? command.name.split(/[:.]+/).pop()
            : command.name; });
        var commandRows = _.map(commandNames, function (commandName) {
            var commandNameParts = commandName.split('|');
            if (commandNameParts.length > 2) {
                commandNameParts = [commandNameParts[0].trim(), _.rest(commandNameParts, 1).join('|').trim()];
            }
            var commandNameIndex = commandNameParts.length === 1 ? 0 : 1;
            _.forEach(replaceCommandDescriptionDictionary, function (replacement) {
                if (commandName.trim().toLowerCase().endsWith(replacement.from.toLowerCase())) {
                    commandNameParts[commandNameIndex] = "".concat(replacement.to, " ").concat(commandNameParts[commandNameIndex].substring(0, commandNameParts[commandNameIndex].toLowerCase().lastIndexOf(replacement.from.toLowerCase())));
                }
            });
            var getColumnStyle = function (width) { return "width: ".concat(width, "px; border: none; padding: 0; text-align: left"); };
            var row = commandNameParts.length === 1
                ? "<td style=\"".concat(getColumnStyle(200), "\"></td><td style=\"").concat(getColumnStyle(700), "\">").concat(commandNameParts[0], "</td>")
                : "<td style=\"".concat(getColumnStyle(200), "\">").concat(commandNameParts[0], "</td><td style=\"").concat(getColumnStyle(700), "\">").concat(commandNameParts[1], "</td>");
            return "<tr>".concat(row, "</tr>");
        }).join('');
        this.selectedOperation.description = "<table style=\"width: 100%; border: none\"><tbody><tr>".concat(commandRows, "</tr></tbody></table>");
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.remove = function (index) {
        if (!this.canEditCommands()) {
            return;
        }
        this.selectedOperation.commands.splice(index, 1);
        for (var i = index; i < this.selectedOperation.commands.length; i++) {
            this.selectedOperation.commands[i].orderNumber = i;
        }
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.moveUp = function (index) {
        if (index == 0 || !this.canEditCommands()) {
            return;
        }
        this.selectedOperation.commands[index].orderNumber--;
        this.selectedOperation.commands[index - 1].orderNumber++;
        this.selectedOperation.commands.splice(index - 1, 0, this.selectedOperation.commands[index]);
        this.selectedOperation.commands.splice(index + 1, 1);
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.moveDown = function (index) {
        if (index === this.selectedOperation.commands.length - 1 || !this.canEditCommands()) {
            return;
        }
        this.selectedOperation.commands[index].orderNumber++;
        this.selectedOperation.commands[index + 1].orderNumber--;
        this.selectedOperation.commands.splice(index + 2, 0, this.selectedOperation.commands[index]);
        this.selectedOperation.commands.splice(index, 1);
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.isValid = function () {
        if (_.isUndefined(this.selectedOperation)) {
            return false;
        }
        var operationNameHTML = this.selectedOperation.description.replace(/\s+/g, ' ').trim();
        var operationNameWithoutHTML = this.removeHtmlFilter(operationNameHTML);
        if (operationNameWithoutHTML === '') {
            return false;
        }
        if (_.any(this.selectedOperation.commands, function (command) {
            return command.tagAddress === '' ||
                command.value === '' ||
                _.isUndefined(command.tagAddress) ||
                _.isUndefined(command.value);
        })) {
            return false;
        }
        if (this.selectedOperation.type === 1 &&
            this.selectedOperation.commands.length === 0) {
            return false;
        }
        return true;
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.canEditCommands = function () {
        return this.authentication.hasPermission(this.$rootScope.permissions.SwitchoverFormTemplateCommandEdit);
    };
    SwitchoverFormTemplateEditOperationModalCtrl.prototype.getDescription = function (descriptionName, orderNumber) {
        var getColumnStyle = function (width) { return "width: ".concat(width, "px; border: none; padding: 0; text-align: left"); };
        var location = this.language.getElementValue('switchoverFormsCommandCpuHdr');
        var name = descriptionName + ' ' + orderNumber.toString();
        return '<table style="width: 100%; border: none">\n' +
            '   <tbody>\n' +
            '       <tr>\n' +
            "           <td style=\"".concat(getColumnStyle(200), "\">").concat(location, "</td>\n") +
            "           <td style=\"".concat(getColumnStyle(700), "\">").concat(name, "</td>\n") +
            '       </tr>\n' +
            '   </tbody>\n' +
            '</table>';
    };
    SwitchoverFormTemplateEditOperationModalCtrl.$inject = [
        '$rootScope',
        '$scope',
        '$modalInstance',
        '$modal',
        'authentication',
        'language',
        'switchoverFormConfigurationProvider',
        'notificationService',
        'switchoverFormsCkeditorConfigurationProvider',
        'removeHtmlFilter',
        'operation',
        'operations',
        'isEditable',
        'isTypical'
    ];
    return SwitchoverFormTemplateEditOperationModalCtrl;
}());
angular
    .module('kamhpp')
    .controller('SwitchoverFormTemplateEditOperationModalCtrl', SwitchoverFormTemplateEditOperationModalCtrl);
