var CalcSettingsCtrl = (function () {
    function CalcSettingsCtrl(parentScope) {
        this.parentScope = parentScope;
    }
    CalcSettingsCtrl.prototype.init = function () {
        this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.parentScope.param.ParameterType);
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    CalcSettingsCtrl.prototype.destroy = function () { };
    CalcSettingsCtrl.prototype.getFormula = function () {
        return this.parentScope.param.Formula;
    };
    CalcSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    CalcSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.canEdited();
    };
    CalcSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.canPlanned();
    };
    CalcSettingsCtrl.prototype.canBacklight = function () {
        var _a;
        var type = ((_a = this.parentScope.param.ParameterType) === null || _a === void 0 ? void 0 : _a.toLowerCase()) || '';
        return !(type === 'table'
            || type.includes('ReportTable')
            || type.includes('[]')
            || type.includes('array')
            || type.includes('chart')
            || type.includes('file')
            || type.includes('xml'));
    };
    CalcSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.canPredefined();
    };
    return CalcSettingsCtrl;
}());
