var HttpSettings = (function () {
    function HttpSettings() {
        this.path = '';
        this.method = 'GET';
        this.body = '';
        this.headers = [];
    }
    HttpSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new HttpSettings();
        clone.connectionGuid = obj.connectionGuid;
        clone.path = obj.path;
        clone.method = obj.method;
        clone.body = obj.body;
        clone.headers = _.deepclone(obj.headers);
        return clone;
    };
    HttpSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.connectionGuid === other.connectionGuid &&
            obj.path === other.path &&
            obj.method === other.method &&
            obj.body === other.body &&
            angular.equals(obj.headers, other.headers));
    };
    HttpSettings.prototype.canEdited = function () {
        return true;
    };
    HttpSettings.prototype.canPlanned = function () {
        return true;
    };
    HttpSettings.prototype.canBacklight = function () {
        return false;
    };
    HttpSettings.prototype.canPredefined = function () {
        return false;
    };
    return HttpSettings;
}());
