var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MsSqlSettingsCtrl = (function (_super) {
    __extends(MsSqlSettingsCtrl, _super);
    function MsSqlSettingsCtrl(codeEditor, modalService, parentScope, language) {
        var _this = _super.call(this, codeEditor, modalService, parentScope) || this;
        _this.parentScope = parentScope;
        _this.language = language;
        _this.functions = [];
        _this.connectionTypes = [0];
        _this.watchFunctions = [];
        return _this;
    }
    MsSqlSettingsCtrl.prototype.init = function () {
        var self = this;
        this.functions = getVariantsContainer(this.parentScope, [
            new SelectSourceFunctionsItem('table', this.language.getElementValue('sqlTableHtmlHdr'), 'ReportTable'),
            new SelectSourceFunctionsItem('doubleArray', this.language.getElementValue('sqlTableNumberHdr'), 'double[][]'),
            new SelectSourceFunctionsItem('objectArray', this.language.getElementValue('reportParameterTypeTableObjectHdr'), 'object[][]'),
            new SelectSourceFunctionsItem('cellString', this.language.getElementValue('reportCellStringHdr'), 'string'),
            new SelectSourceFunctionsItem('cellDouble', this.language.getElementValue('reportCellNumberHdr'), 'double'),
            new SelectSourceFunctionsItem('stringOneDimArray', this.language.getElementValue('sqlStringSetHdr'), 'string[]'),
        ], function (t) {
            return t.ident === self.parentScope.param.MsSql.func;
        }, function (after, before) {
            if (after === before)
                return;
            if (after == undefined || after === before)
                return;
            self.parentScope.param.MsSql.func = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
            if (!self.canEdited()) {
                self.parentScope.param.Editable = false;
            }
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.parentScope.param.MsSql;
        }, function (before, after) {
            if (_.isUndefined(self.parentScope.param.MsSql) ||
                _.isNull(self.parentScope.param.MsSql) ||
                after == undefined) {
                return;
            }
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        }, true));
        this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.functions.selected.returnType);
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    MsSqlSettingsCtrl.prototype.onCodeEditorChange = function (change) {
        this.parentScope.param.MsSql.sql = change.code;
    };
    MsSqlSettingsCtrl.prototype.destroy = function () {
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    };
    MsSqlSettingsCtrl.prototype.getFormula = function () {
        var connectionGuid = this.parentScope.param.MsSql.connectionGuid;
        var sql = ReportFormulaEscaper.escape(this.parentScope.param.MsSql.sql, this.parentScope.reportTemplate.Parameters);
        switch (this.functions.selected.ident) {
            case 'table':
                return ('return SqlQueryAsHtmlTableByConnection("' +
                    connectionGuid +
                    '", ' +
                    sql +
                    ', ' +
                    this.parentScope.param.MsSql.includeHeader +
                    ');');
            case 'doubleArray':
                return 'return SqlQueryAsDoubleArrayByConnection("' + connectionGuid + '", ' + sql + ');';
            case 'objectArray':
                return 'return SqlQueryAsObjectArrayByConnection("' + connectionGuid + '", ' + sql + ');';
            case 'cellString':
                return 'return SqlQueryAsStringByConnection("' + connectionGuid + '", ' + sql + ', 0, 0);';
            case 'cellDouble':
                return 'return SqlQueryAsDoubleByConnection("' + connectionGuid + '", ' + sql + ', 0, 0);';
            case 'stringOneDimArray':
                return 'return SqlQueryAsStringArrayByConnection("' + connectionGuid + '", ' + sql + ')[0];';
        }
        return '';
    };
    MsSqlSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    MsSqlSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.MsSql.canEdited();
    };
    MsSqlSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.MsSql.canPlanned();
    };
    MsSqlSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.MsSql.canBacklight();
    };
    MsSqlSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.MsSql.canPredefined();
    };
    return MsSqlSettingsCtrl;
}(DatabaseSettingsBaseCtrl));
