var DatabaseSettingsBaseCtrl = (function () {
    function DatabaseSettingsBaseCtrl(codeEditor, modalService, parentScope) {
        var _this = this;
        this.modalService = modalService;
        this.parentScope = parentScope;
        this.codeEditor = codeEditor;
        this.completions = _.map(_.filter(this.parentScope.reportTemplate.Parameters, function (parameter) { return parameter.Ident != _this.parentScope.param.Ident; }), function (parameter) { return ({
            caption: "".concat(parameter.Ident),
            value: "%".concat(parameter.Ident, "%"),
            meta: 'parameter'
        }); });
    }
    DatabaseSettingsBaseCtrl.prototype.insertParamAddress = function () {
        var _this = this;
        var modalInstance = this.modalService.open({
            templateUrl: 'ng1/dist/src/UserDocuments/Administration/ParameterSelectModal.html',
            controller: 'parameterSelectModalCtrl',
            backdrop: 'static',
            windowClass: 'app-modal-window',
            resolve: {
                parameters: function () {
                    return _.filter(_this.parentScope.reportTemplate.Parameters, function (parameter) { return parameter.Ident !== _this.parentScope.param.Ident; });
                }
            }
        });
        modalInstance.result.then(function (parameter) {
            _this.codeEditor.insert("%".concat(parameter.Ident, "%"));
            _this.codeEditor.focus();
        }, function () { });
    };
    DatabaseSettingsBaseCtrl.prototype.onCodeEditorInitialized = function (codeEditor) {
        this.codeEditor = codeEditor;
        this.codeEditor.focus();
    };
    return DatabaseSettingsBaseCtrl;
}());
