var ReportParameterEditModalCtrl = (function () {
    function ReportParameterEditModalCtrl($scope, $rootScope, $modal, $modalInstance, language, $http, notificationService, clientSettings, param, reportTemplate, operationTimeParameterProvider, opcConnectionProvider, $q, blockUI, winCCOAProvider, userProviderService, reportTemplateProviderService, authentication, permissionService, formulaFactory, $timeout, reportCompletionsProvider) {
        var watchFunctions = [];
        var initialParameterIdent = param.Ident;
        $scope.param = param;
        $scope.reportTemplate = reportTemplate;
        $scope.showPeriods = false;
        $scope.showTwoTimestamp = false;
        $scope.blockUI = blockUI;
        $scope.getSelectedItem = function (items, paramValue) {
            var item = _.find(items, function (i) {
                return i.ident === paramValue;
            });
            return item == undefined
                ? new UiSelectItem(paramValue, paramValue)
                : item;
        };
        $scope.settingsCtrl = new ParameterSourceSettingCtrl($scope, $rootScope, $http, userProviderService, reportTemplateProviderService, clientSettings, notificationService, $modal, opcConnectionProvider, language, $q, operationTimeParameterProvider, authentication, permissionService, winCCOAProvider, formulaFactory, $timeout, reportCompletionsProvider);
        $scope.settingsCtrl.init();
        $scope.backlightCtrl = new ParameterBacklightSettingCtrl($scope, language);
        $scope.tabs = [
            { name: language.getElementValue('reportParameterSettingsHdr'), ctrl: $scope.settingsCtrl, isSelected: false },
            { name: language.getElementValue('reportParameterAdditionalSettingsHdr'), ctrl: undefined, isSelected: false },
            { name: language.getElementValue('backlightHdr'), ctrl: $scope.backlightCtrl, isSelected: false }
        ];
        $scope.setActiveTab = function (tabIndex) {
            _.each($scope.tabs, function (t, i) {
                if (i === tabIndex) {
                    switch (tabIndex) {
                        case 0:
                            $scope.settingsCtrl.parameterSettingDisplayMode
                                = $scope.param.Source === 'calc'
                                    ? 'formula'
                                    : 'settings';
                            break;
                        case 1:
                            $scope.backlightCtrl.openAllItems();
                            break;
                    }
                    t.isSelected = true;
                }
                else {
                    t.isSelected = false;
                }
            });
        };
        $scope.openHelp = function () {
            $modal.open({
                templateUrl: 'ng1/dist/src/UserDocuments/Administration/ParameterEditModal/HelpModal.html',
                controller: 'parameterEditHelpModalCtrl',
                windowClass: 'app-modal-window-help',
                backdrop: 'static'
            });
        };
        $scope.ok = function () {
            $scope.param.Source = $scope.settingsCtrl.sources.selected.ident;
            $scope.param.Formula = $scope.settingsCtrl.formulaCtrl.codeEditor.getValue();
            if ($scope.param.Ident == undefined || $scope.param.Ident.trim() === '') {
                notificationService.warnMessage(language.getElementValue('reportParameterNameIsNotEmptyMsg'));
                return;
            }
            if ($scope.param.Ident.indexOf('%') !== -1) {
                notificationService.warnMessage(language.getElementValue('reportnParameterNameIsNotContainsPercentMsg'));
                return;
            }
            var existingSameNameParameter = _.find($scope.reportTemplate.Parameters, function (parameter) {
                return param.Ident !== initialParameterIdent && parameter.Ident === $scope.param.Ident;
            });
            if (!_.isUndefined(existingSameNameParameter)) {
                notificationService.warnMessage(language.getElementValue('parameterNameMustBeUniqMsg'));
                return;
            }
            if ($scope.param.Source === 'aggregation'
                && ($scope.param.Aggregation.sourceParameterIdent === undefined
                    || $scope.param.Aggregation.sourceParameterIdent === null)) {
                notificationService.warnMessage(language.getElementValue('reportParameterMustChooseParameterForAggregationMsg'));
            }
            $modalInstance.close($scope.param);
        };
        $scope.cancel = function () {
            $modalInstance.dismiss();
        };
        watchFunctions.push($scope.$on('$destroy', function () {
            $scope.settingsCtrl.destroy();
            $scope.backlightCtrl.destroy();
            for (var i = 0; i < watchFunctions.length; i++) {
                var func = watchFunctions[i];
                if (!_.isUndefined(func)) {
                    func();
                }
            }
        }));
        $scope.setActiveTab(0);
        $scope.isShowTab = function (tab) {
            var backlightTabName = language.getElementValue('backlightHdr');
            var canBacklight = $scope.settingsCtrl.sourceCtrl.canBacklight();
            return tab.name !== backlightTabName || canBacklight;
        };
    }
    ReportParameterEditModalCtrl.$inject = [
        '$scope',
        '$rootScope',
        '$modal',
        '$modalInstance',
        'language',
        '$http',
        'notificationService',
        'clientSettings',
        'parameter',
        'reportTemplate',
        'operationTimeParameterProvider',
        'opcConnectionProvider',
        '$q',
        'blockUI',
        'winCCOAProvider',
        'userProvider',
        'reportTemplateProvider',
        'authentication',
        'permissionService',
        'chartFormulaFactory',
        '$timeout',
        'reportCompletionsProvider'
    ];
    return ReportParameterEditModalCtrl;
}());
app.controller('ReportParameterEditModalCtrl', ReportParameterEditModalCtrl);
