var ReportFormula = (function () {
    function ReportFormula(formula) {
        this.isChanged = false;
        this.id = formula.id;
        this.name = formula.name;
        this.code = formula.code;
        this.returnType = formula.returnType;
        this.parameters = _.deepclone(formula.parameters);
    }
    ReportFormula.clone = function (original) {
        if (_.isUndefined(original)) {
            return original;
        }
        var clone = {
            id: original.id,
            name: original.name,
            code: original.code,
            returnType: original.returnType,
            parameters: _.deepclone(original.parameters)
        };
        return clone;
    };
    ReportFormula.isEqual = function (formula, other) {
        if (formula.parameters.length !== other.parameters.length) {
            return false;
        }
        if (_.any(formula.parameters, function (p, i) {
            return p.name !== other.parameters[i].name
                || p.type !== other.parameters[i].type;
        })) {
            return false;
        }
        return formula.id === other.id
            && formula.name === other.name
            && formula.code === other.code
            && formula.returnType === other.returnType;
    };
    return ReportFormula;
}());
