var LogFieldDateTimeDefaultValue;
(function (LogFieldDateTimeDefaultValue) {
    LogFieldDateTimeDefaultValue[LogFieldDateTimeDefaultValue["Now"] = 2] = "Now";
    LogFieldDateTimeDefaultValue[LogFieldDateTimeDefaultValue["StartTimeReport"] = 1] = "StartTimeReport";
    LogFieldDateTimeDefaultValue[LogFieldDateTimeDefaultValue["None"] = 0] = "None";
})(LogFieldDateTimeDefaultValue || (LogFieldDateTimeDefaultValue = {}));
app.controller('reportNewLogRowCtrl', function ($scope, $modalInstance, fields, rows, notificationService, language, ts) {
    $scope.rows = rows;
    $scope.fields = _.deepclone(fields);
    $scope.row = {
        cells: [],
        isDeleted: false
    };
    var _loop_1 = function (i) {
        if ($scope.fields[i].type === 'datetime') {
            if ($scope.fields[i].defaultValue === LogFieldDateTimeDefaultValue.Now) {
                $scope.fields[i].defaultValue = new Date();
            }
            else if ($scope.fields[i].defaultValue === LogFieldDateTimeDefaultValue.StartTimeReport) {
                $scope.fields[i].defaultValue = moment(ts, 'DD.MM.YYYY HH:mm:ss').toDate();
            }
            else {
                $scope.fields[i].defaultValue = null;
            }
        }
        var cell = {
            value: undefined,
            parameter: $scope.fields[i].caption,
            variations: _.map($scope.fields[i].additionalSettings, function (variation) {
                return new UiSelectItem(variation, variation);
            }),
        };
        cell.variations.selected = _.find(cell.variations, function (item) {
            return item.ident === $scope.fields[i].defaultValue;
        });
        if (_.isUndefined($scope.fields[i].defaultValue) || _.isNull($scope.fields[i].defaultValue)) {
            switch ($scope.fields[i].type) {
                case 'string':
                    cell.value = '';
                    break;
                case 'time':
                    cell.value = '';
                    break;
                case 'timespan':
                    cell.value = '00:00:00';
                    break;
                case 'datetime': {
                    if (fields[i].isRequired)
                        cell.value = new Date();
                    break;
                }
                default:
                    cell.value = null;
            }
        }
        else {
            cell.value = $scope.fields[i].defaultValue;
        }
        $scope.row.cells.push(cell);
    };
    for (var i = 0; i < $scope.fields.length; i++) {
        _loop_1(i);
    }
    $scope.isEmptyRequiredFields = function () {
        for (var i = 0; i < $scope.fields.length; i++) {
            if ($scope.fields[i].isRequired) {
                var rowCell = $scope.row.cells[i];
                if ((_.isUndefined(rowCell.value) || _.isNull(rowCell.value) || rowCell.value === '') &&
                    _.isUndefined(rowCell.variations.selected)) {
                    return true;
                }
            }
        }
        return false;
    };
    var fillLogRowExtendedCellValues = function () {
        for (var i = 0; i < $scope.fields.length; i++) {
            if ($scope.fields[i].type === 'dropdown') {
                var variations = $scope.row.cells[i].variations;
                if (!_.isUndefined(variations.selected)) {
                    $scope.row.cells[i].value = variations.selected.ident;
                }
            }
        }
    };
    $scope.ok = function () {
        fillLogRowExtendedCellValues();
        var currentKeyCells = getKeyCells(fields, $scope.row);
        var isKeyAlreadyExists = _.any(_.filter($scope.rows, function (row) { return !row.isDeleted; }), function (row) {
            var keyCells = getKeyCells(fields, row);
            return _.isEqual(keyCells, currentKeyCells);
        });
        if (isKeyAlreadyExists) {
            notificationService.warnMessage(language.getElementValue('smsReportNewLogRowDialogRowWithSuchKeyFieldsIsAlreadyAvalibleMsg'));
        }
        else {
            $modalInstance.close($scope.row);
        }
    };
    $scope.cancel = function () {
        $modalInstance.dismiss('cancel');
    };
    $scope.checkAvailabilityOfKeyFields = function () {
        return _.any($scope.fields, function (field) { return field.isKey; });
    };
    $scope.focus = function ($event, index) {
        if (index === 0) {
            $event.target.focus();
        }
    };
    var getKeyCells = function (fields, row) {
        if (_.any(fields, function (field) { return field.isKey; })) {
            var keyCells = [];
            for (var i = 0; i < fields.length; i++) {
                if (fields[i].isKey) {
                    keyCells.push({ value: row.cells[i].value, parameter: row.cells[i].parameter });
                }
            }
            return keyCells;
        }
        else {
            return row.cells;
        }
    };
});
